from viavi.evm import *
from viavi.diag import *
from viavi.mts import getMachineName

LedsConfigurations = {
    "mts4000ng": {
        "ON":"on",
        "CHARGE_GREEN":"charge_green",
        "CHARGE_RED":"charge_red",
        "TESTING":"led_test",
        "HOME":"home",
        "APPS":"apps",
        "START":"start_stop",
        "UP":"arrow_up",
        "DOWN":"arrow_down",
        "RIGHT":"arrow_right",
        "LEFT":"arrow_left",
        "ENTER":"enter"
    },
    "mts2000ng": {
        "ON":"on",
        "CHARGE_GREEN":"charge_green",
        "CHARGE_RED":"charge_red",
        "TESTING":"led_test"
    },
    "mts1000": {
        "ON":"led_power",
        "CHARGE_GREEN":"led_ch_green",
        "CHARGE_ORANGE":"led_ch_orange",
        "TEST":"led_test",
        "PORT1":"led_13_15",
        "PORT2":"led_16"
    },
    "eotdrv2": {
        "TEST":"led_test",
        "SOFT_UPG":"led_soft_upg"
    },
    "nanoeotdr": {
        "TEST":"led_test",
        "SOFT_UPG":"led_soft_upg",
        "ON_R":"led_on_r",
        "ON_G":"led_on_g",
        "STATUS_R":"led_status_r",
        "ETH":"led_eth",
    }
}


@DIAG("Led test")
def t_led(cmd):
    conf = LedsConfigurations[getMachineName()]
    try:
        (command,led,mode) = cmd.split()
    except:
        print_error("# Command must be: t_led <%s> <ON|OFF>"%("|".join(conf.keys())))
        return False

    if led not in conf.keys() or mode not in ("ON","OFF"):
        print_error("# Command must be: t_led <%s> <ON|OFF>"%("|".join(conf.keys())))
        return False
    if mode == "ON":
        sysfs_write("/sys/class/leds/%s/brightness" % conf[led], 1)
    else:
        sysfs_write("/sys/class/leds/%s/brightness" % conf[led], 0)
    return None

