import QtQuick 2.1

import common 1.0
import graph_plugin 1.0

FocusScope { id: root

    property alias view: worldView.view
    default property alias plots: plotContainer.data
    property alias minimumValue: zoomControl.minimumValue
    property alias maximumValue: zoomControl.maximumValue
    property alias stepSize: zoomControl.stepSize
    property alias value: zoomControl.value

    function toggleZoomPan() {
        zoomToggle.currentIndex = zoomToggle.currentIndex ^ 1;
    }

    function updateZoom() {
        zoomControl.value = Math.log(1.0 / worldView.zoomRect.width) / Math.LN2;
    }

    ButtonSlider { id: zoomToggle
        anchors {
            leftMargin: 8
            topMargin: 8
            bottomMargin: 8
            left: parent.left
            top: parent.top
            bottom: parent.bottom
        }
        width: 88
        focus: false
        orientation: ListView.Vertical
        model:  ListModel {
            ListElement { text: "Zoom" }
            ListElement { text: "Pan" }
        }
    }

    Rectangle { id: worldBackground
        anchors {
            leftMargin: 20
            rightMargin: 20
            topMargin: 8
            bottomMargin: 8
            left: zoomToggle.right
            right: parent.right
            top: parent.top
            bottom:parent.bottom
        }
        focus: false
        border.width: 1
        border.color: "#666666"
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#D0D1D2" }
            GradientStop { position: 0.2; color: "#EAEBEC" }
            GradientStop { position: 0.6; color: "#F1F2F3" }
            GradientStop { position: 1.0; color: "#F1F2F3" }
        }

//        BorderImage { id: shadow
//            border { left: 15; right: 15; top: 15; bottom: 15 }
//            anchors { fill: parent; leftMargin: -8; rightMargin: -8; topMargin: -4; bottomMargin: -12 }
//            source: theme.dynamicDirPrefix + "focus_048"
//            visible: zoomScope.activeFocus
//        }
    }

    WorldView { id: worldView
        anchors.margins: 1
        anchors.fill: worldBackground
        focus: (zoomToggle.currentIndex === 1)

        Item { id: plotContainer
            anchors.fill: parent
        }

        WorldCurtain { id: curtain
            anchors.fill: parent
            zoomRect: worldView.zoomRect
            onLeftBoundChanged: leftHandle.x = leftBound;
            onRightBoundChanged: rightHandle.x = rightBound;
        }

        BorderImage { id: leftHandle
            anchors {
                topMargin: -4
                bottomMargin: -4
                top: parent.top
                bottom: parent.bottom
            }
            x: 0
            //border { left: 0; right: 3; top: 3; bottom: 33 }
            //source: theme.dynamicDirPrefix + "graph_selector_left"
            //transform: Translate { x: -23}
            border { left: 1; right: 1; top: 1; bottom: 1 }
            source: theme.dynamicDirPrefix + (dragLeft.pressed ? "selector_handle_pressed" : "selector_handle")
            transform: Translate { x: -20 }
            visible: worldView.focus

            MouseArea { id: dragLeft
                anchors.leftMargin: -20
                anchors.fill: parent
                drag.target: parent
                drag.axis: Drag.XAxis
                drag.minimumX: 0
                drag.maximumX: rightHandle.x - worldView.width * worldView.zoomRect.minWidth
            }
            onXChanged: worldView.zoomRect.setLeft(x / worldView.width);
        }

        BorderImage { id: rightHandle
            anchors {
                topMargin: -4
                bottomMargin: -4
                top: parent.top
                bottom: parent.bottom
            }
            x: parent.width
            //border { left: 3; right: 0; top: 3; bottom: 33 }
            //source: theme.dynamicDirPrefix + "graph_selector_right"
            border { left: 1; right: 1; top: 1; bottom: 1 }
            source: theme.dynamicDirPrefix + (dragRight.pressed ? "selector_handle_pressed" : "selector_handle")
            visible: worldView.focus

            MouseArea { id: dragRight
                anchors.rightMargin: -20
                anchors.fill: parent
                drag.target: parent
                drag.axis: Drag.XAxis
                drag.minimumX: leftHandle.x + worldView.width * worldView.zoomRect.minWidth
                drag.maximumX: worldView.width
            }
            onXChanged: worldView.zoomRect.setRight(x / worldView.width);
        }

        Keys.onLeftPressed: {
            var newLeft = worldView.zoomRect.left - worldView.zoomRect.width / 10;
            worldView.zoomRect.moveLeft(newLeft);
        }
        Keys.onRightPressed: {
            var newLeft = worldView.zoomRect.left + worldView.zoomRect.width / 10;
            worldView.zoomRect.moveLeft(newLeft);
        }
    }

    Slider { id: zoomControl
        anchors {
            margins: 8
            left: worldView.left
            right: worldView.right
            bottom: worldView.bottom
        }
        visible: (zoomToggle.currentIndex === 0) //&& !pinchArea.pinching
        focus: visible
        minimumValue: 0
        maximumValue: 6
        orientation: Qt.Horizontal
        stepSize: 0.5
        valueIndicatorVisible: true
        __mouseMarginTop: -zoomControl.y

        onValueChanged: { worldView.zoomRect.zoomX(1.0/Math.pow(2.0, value), cursor.position); }
        onVisibleChanged: { if (visible) updateZoom(); }
        Component.onCompleted: { value = 0; }

        Keys.onLeftPressed: value -= stepSize;
        Keys.onRightPressed: value += stepSize;
    }
}
