import QtQuick 2.1

import common 1.0
import graph_plugin 1.0

Column { id: label

    property color color: !!_parentMarker ? _parentMarker.color : "black"
    property alias text: value.text

    property bool markAbove: !!_parentMarker ? (_parentMarker.yValue > 0.0) : true
    property int xPos: !!_parentMarker ? _parentMarker.xPosOnScreen : 0
    property int xCenter: Math.ceil(label.width / 2)

    spacing: -8
    visible: !!_parentMarker ? (_parentMarker.visible && xPos >= 0 && xPos < parent.width) : false
    width: markerRow.width
    x: Math.max(xPos - xCenter, 0)
    y: {
        var yPos = !!_parentMarker ? _parentMarker.yPosOnScreen : 0.0
        return (markAbove) ? yPos - height : yPos;
    }

    ColorKeyImage { id: upArrow
        anchors {
            horizontalCenter: parent.horizontalCenter
            horizontalCenterOffset: label.xPos - (label.x + xCenter)
        }
        source: theme.dirPrefix + "play-32"
        color: label.color
        rotation: 270
        visible: !markAbove
    }

    Row { id: markerRow
        ColorKeyImage { id: leftImg
            source: theme.dirPrefix + "marker-label-left"
            color: label.color
        }

        Item {
            width: Math.ceil(column.childrenRect.width)
            height: leftImg.height
            ColorKeyImage {
                anchors.fill: parent
                source: theme.dirPrefix + "marker-label-center"
                color: label.color
            }
            Column { id: column
                anchors.verticalCenter: parent.verticalCenter
                spacing: 0
                Text { id: xValue
                    anchors.horizontalCenter: parent.horizontalCenter
                    color: "#FFFFFF"
                    font: systemFont.HeaderFont
                    text: !!_parentMarker ? _parentMarker.formattedPosValue : ""
                }
                Text { id: value
                    anchors.horizontalCenter: parent.horizontalCenter
                    font: systemFont.LargeTitleFont
                    color: label.color
                }

            }
        }

        ColorKeyImage {
            source: theme.dirPrefix + "marker-label-right"
            color: label.color
        }
    }

    ColorKeyImage { id: downArrow
        anchors {
            horizontalCenter: parent.horizontalCenter
            horizontalCenterOffset: label.xPos - (label.x + xCenter)
        }
        source: theme.dirPrefix + "play-32"
        color: label.color
        rotation: 90
        visible: markAbove
    }

    // For internal use only!!!
    property QtObject _parentMarker: null
}
