import QtQuick 2.5

import com.viavi.style 1.0

Rectangle {
    id: numericKeyboard

    width: keyboardUtils.widthNumericKeyb
    height: keyboardUtils.heightNumericKeyb

    x: keyboardUtils.xNumericKeyb
    y: keyboardUtils.yNumericKeyb

    color: ViaviColor.alternativeBackgroundColor

    property alias maxValue: numericalKeys.maxValue
    property alias minValue: numericalKeys.minValue
    property alias autoValue: numericalKeys.autoValue

    property string maxValueString: maxValue !== undefined ? maxValue : ""
    property string minValueString: minValue !== undefined ? minValue : ""
    property string autoValueString: autoValue !== undefined ? autoValue : ""

    property alias alternativeKeysModel: numericalKeys.alternativeKeysModel

    property alias dotIsAllowed: numericalKeys.dotIsAllowed

    property alias configurableButtonPicturePath: commonKeys.configurableButtonPicturePath
    property alias configurableButtonEnabled: commonKeys.configurableButtonEnabled
    property alias hasDefaultButton: commonKeys.hasDefaultButton
    property alias initialText: keyboardText.initialText
    property alias textField: keyboardText.textField
    property alias titleDescription: keyboardText.titleDescription
    property alias titleText: keyboardText.titleText
    property alias hasTitleAction: keyboardText.hasTitleAction
    property alias inputTextMaxLength: keyboardText.inputTextMaxLength
    property alias cursorPos: keyboardText.cursorPos

    signal titleClicked()
    signal canceled()
    signal accepted()
    signal configurableButtonClicked()
    signal inputTextChanged(string newText)

    /* Handle custom/specific button behavior */
    function customButtonClicked( button )
    {
        switch ( button ){
        case "Enter":
            numericKeyboard.accepted()
            break
        case "Cancel":
            numericKeyboard.canceled()
            break;
        case "Configurable":
            numericKeyboard.configurableButtonClicked()
            break;
        case "Back":
            var pos = keyboardText.cursorPos
            if( !(pos === 1
                    && keyboardText.maxValue !== undefined && keyboardText.maxValue < 0
                    && keyboardText.textField[0] === "-") ){ //don't delete the minus if only negative values are allowed
                keyboardText.textField = keyboardText.textField.substring ( 0, pos - 1) +
                                         keyboardText.textField.substring( pos, keyboardText.textField.length )
                keyboardText.cursorPos = pos - 1
            }

            if(keyboardText.maxValue !== undefined && keyboardText.maxValue < 0 && !keyboardText.textField){
                keyboardText.textField = "-"
                keyboardText.cursorPos = 1
            }

            break
        case "Clear":
            if(numericKeyboard.maxValue !== undefined && numericKeyboard.maxValue < 0){
                keyboardText.textField = "-"
                keyboardText.cursorPos = 1
            } else {
                keyboardText.textField = ""
            }
            break
        case "Min":
            if(numericKeyboard.minValueString !== undefined){
                keyboardText.textField = numericKeyboard.minValueString
            }
            break
        case "Max":
            if(numericKeyboard.maxValueString !== undefined){
                keyboardText.textField = numericKeyboard.maxValueString
            }
            break
        case "Auto":
            keyboardText.textField = "Auto"
            break
        case "None":
            keyboardText.textField = "None"
            break
        case "All":
            keyboardText.textField = "All"
            break
        case "Default":
            keyboardText.textField = numericKeyboard.autoValueString
            break
        case "+/-":
            if ( keyboardText.textField[0] === "-" )
            {
                keyboardText.textField = "+" + keyboardText.textField.substring( 1 , keyboardText.textField.length )
            } else if ( keyboardText.textField[0] === "+" )
            {
                keyboardText.textField = "-" + keyboardText.textField.substring( 1 , keyboardText.textField.length )
            } else if ( ( '0' <= keyboardText.textField[0] ) && ( keyboardText.textField[0] <= '9' ))
            {
                keyboardText.textField = "-" + keyboardText.textField
            } else if (!keyboardText.textField) {
                keyboardText.textField = "-"
            }

            break
        default:
            break
        }
    }

    /* normal caracter/digit is clicked and will be added to the string */
    function charButtonClicked ( button )
    {
        var pos = keyboardText.cursorPos
        keyboardText.textField = keyboardText.textField.substring ( 0, pos ) + button +
                keyboardText.textField.substring( pos, keyboardText.textField.length )
        keyboardText.cursorPos = pos + 1
    }


    KeyboardHeader {
        id: keyboardText

        onTitleClicked: numericKeyboard.titleClicked()
        onInputTextAccepted: numericKeyboard.accepted()
        onInputTextChanged: numericKeyboard.inputTextChanged(newText)
    }

    Item {

        anchors.top: keyboardText.bottom
        anchors.topMargin: keyboardUtils.keyboardVerticalMargin
        anchors.bottom: parent.bottom
        anchors.bottomMargin: keyboardUtils.keyboardVerticalMargin
        anchors.right: parent.right
        anchors.rightMargin: keyboardUtils.keyboardHorizontalMargin
        anchors.left: parent.left
        anchors.leftMargin: keyboardUtils.keyboardHorizontalMargin

        /* Specific keys for numerical Keyboard */
        KeyboardNumericalKeys {
            id: numericalKeys
        }

        /* common keys in the right side column (Back, Clear, Cancel, Enter) */
        KeyboardCommonKeys {
            id: commonKeys
        }
    }
}



