import QtQuick 2.5

import com.viavi.style 1.0
import com.viavi.style.components 1.0

KeyboardButton {

    property bool buttonHasPicture      : false
    property string buttonPicturePath   : ""
    property bool buttonIsCommon        : false

    buttonWidth: keyboardUtils.buttonWidthCustom
    buttonBackgroundColor: buttonPressed ? ViaviColor.activeColor :
                           buttonIsCommon ? ViaviColor.keyboardButtonCustomColor : ViaviColor.contentBackgroundColor
    buttonType: keyboardUtils.buttonTypeCustom
    buttonLabelVisible: buttonEnabled && !buttonHasPicture

    ColorImage {

        visible: buttonHasPicture

        width: parent.width * 0.4
        height: parent.height * 0.6

        opacity: buttonEnabled ? 1.0 : 0.3

        anchors.centerIn: parent

        source: buttonPicturePath
        fillMode: Image.PreserveAspectFit
        smooth: true

        color: buttonPressed ? ViaviColor.activeItemTextColor : ViaviColor.activeColor
    }
}



