import QtQuick 2.5


Column {

    anchors.right: parent.right
    anchors.top: parent.top
    anchors.bottom: parent.bottom

    width: keyboardUtils.buttonWidthCommon

    property alias configurableButtonPicturePath: configurableButton.buttonPicturePath
    property alias configurableButtonEnabled: configurableButton.buttonEnabled
    property bool hasDefaultButton: false

    KeyboardCustomButton {
        buttonLabel: "Back"
        buttonIsCommon: true
        buttonHasPicture: true
        buttonPicturePath: keyboardUtils.buttonIconPath + "Icon_Backspace.png"
    }

    KeyboardCustomButton {
        buttonLabel: "Clear"
        buttonIsCommon: true
        buttonHasPicture: true
        buttonPicturePath: keyboardUtils.buttonIconPath + "Icon_Broom.png"
    }

    KeyboardCustomButton {
        id: configurableButton
        visible: buttonPicturePath
        buttonLabel: "Configurable"
        buttonIsCommon: true
        buttonHasPicture: true
    }

    KeyboardCustomButton {
        id: defaultButton
        visible: (!configurableButton.visible) && hasDefaultButton
        buttonLabel: "Default"
        buttonIsCommon: true
        buttonHasPicture: true
        buttonPicturePath: keyboardUtils.buttonIconPath + "Icon_Default.png"
    }

    /* Empty space */
    Item {
        visible: !configurableButton.visible && !defaultButton.visible
        width: parent.width
        height: parent.height / 5
    }

    KeyboardCustomButton {
        buttonLabel: "Cancel"
        buttonIsCommon: true
        buttonHasPicture: true
        buttonPicturePath: keyboardUtils.buttonIconPath + "Wizard_Icon_Clear.png"
    }

    KeyboardCustomButton {
        buttonLabel: "Enter"
        buttonIsCommon: true
        buttonHasPicture: true
        buttonPicturePath: keyboardUtils.buttonIconPath + "checkmark.png"
    }
}

