import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.3

import com.viavi.style 1.0
import com.viavi.style.components 1.0

//Note: this is of type Control instead of RowLayout to allow mouse area anchoring at ViaviMenuLineSwitch
Control {
    property alias textLeft: left.text
    property alias textRight: viaviSwitch.text
    property alias checked: viaviSwitch.checked

    contentItem: RowLayout {
        spacing: 0

        Text {
            id: left
            font: viaviSwitch.font
            MouseArea {
                id: mouseArea
                anchors.fill: parent
                onClicked: viaviSwitch.toggle()
            }
            //NOTE: this colour effect is not implemented over mouseArea
            color: viaviSwitch.contentItem.color
        }
        ViaviSwitch {
            id: viaviSwitch
        }
    }
}
