import QtQuick 2.9
import QtQuick.Controls 2.3

import com.viavi.style 1.0

Switch {
    id: control

    font: ViaviStyle.layout.mediumFont

    readonly property double opacityDisabled: 0.2
    readonly property double opacityUnChecked: 0.5

    indicator: Rectangle {
        width: control.height * 2
        height: control.height / 2

        x: control.leftPadding
        anchors.verticalCenter: parent.verticalCenter
        radius: height
        color: control.checked ? ViaviStyle.colors.selectedBackgroundColor : ViaviStyle.colors.deselectedBackgroundColor
        border.color: color


        Rectangle {
            id: indicatorTip
            x: control.checked ? parent.width - width : 0
            anchors.verticalCenter: parent.verticalCenter
            height: control.height
            width: height
            radius: width / 2
            color: {
                if (enabled) {
                    if (checked) return ViaviStyle.colors.activeColor
                    else return ViaviStyle.colors.selectedBackgroundColor
                }
                else return ViaviStyle.colors.disabledItemColor
            }

            border.color: enabled ? ViaviStyle.colors.activeColor : ViaviStyle.colors.disabledItemColor
        }
    }

    contentItem: Text {
        id: label
        text: control.text
        font: control.font
        color: {
            if (enabled) {
                if (control.down) return ViaviStyle.colors.activeColor
                else return ViaviStyle.colors.mainInfoColor
            }
            else return ViaviStyle.colors.disabledItemColor
        }
        verticalAlignment: Text.AlignVCenter
        leftPadding: control.indicator.width + control.spacing
    }
}
