import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0

Control {
    id: root

    implicitHeight: contentItem.implicitHeight
    implicitWidth: contentItem.implicitWidth
    padding: 0

    property alias text: lineTitleText.text
    property int textWidth: ViaviStyle.layout.menuTitleWidth
    property int textHeight: ViaviStyle.layout.menuLineHeight

    property bool mainContentFillWidth: false
    property bool tailContentFillWidth: false
    property int mainContentWidth: -1
//    property int tailContentWidth: -1

    property Component mainContentItem: null
    property Component tailContentItem: null

    property alias backgroundColor: backgroundRect.color

    property int contentSpacing: ViaviStyle.layout.mediumMargin

    background: Rectangle {
        id: backgroundRect
        anchors.fill: parent
        color: ViaviStyle.colors.contentBackgroundColor
    }

    contentItem: RowLayout {
        anchors.fill: parent

        spacing: root.contentSpacing

        Text {
            id: lineTitleText

            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignVCenter

            font: ViaviStyle.layout.activeTextFont
            color: enabled ? ViaviStyle.colors.mainInfoColor : ViaviStyle.colors.disabledItemColor

            wrapMode: Text.Wrap
            Layout.preferredWidth: textWidth
            Layout.preferredHeight: textHeight
        }

        Loader {
            id: mainContentItemLoader
            sourceComponent: mainContentItem
            Layout.preferredWidth : mainContentWidth
            Layout.fillWidth: mainContentFillWidth            
        }

        Loader {
            id: tailContentIemLoader
            sourceComponent: tailContentItem
            Layout.fillWidth: tailContentFillWidth
        }
    }
}
