import QtQml 2.3
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.style.components.menudata 1.0

ViaviMenuLineControl {
    id: root

    property alias comboBoxData: comboProperties
    property int comboboxWidth: ViaviStyle.layout.menuTextFieldWidth
    ComboBoxData {
        id: comboProperties
    }
    mainContentItem: ViaviComboBox {
        id: comboBox
        model: comboProperties.model
        currentIndex: comboProperties.currentIndex
        Connections{
                target: comboProperties
                function onCurrentIndexChanged(){
                    comboBox.currentIndex = comboProperties.currentIndex
        	}
        }
        onCurrentIndexChanged: {
            if (comboProperties.currentIndex !== currentIndex)
                comboProperties.currentIndex = currentIndex;
        }
        enabled: comboProperties.enabled
        visible: comboProperties.visible
        Binding {
            target: comboProperties
            property: 'currentText'
            value: comboBox.currentText
        }
        Binding {
            target: comboProperties
            property: 'count'
            value: comboBox.count
        }
        
        implicitHeight: ViaviStyle.layout.setupMenuLineHeight
        implicitWidth: root.comboboxWidth
    }
}
