import QtQuick 2.3

import com.viavi.style 1.0


//NOTE: this can be replaced/rewritten in terms of Switch (Qt 5.7)
Rectangle {
    property bool toggled: false
    property int toggleSize: 100
    property bool isWizardButton: false
    property color buttonOptionSelected: ViaviColor.activeColor
    property color buttonOptionUnselected: ViaviColor.contentBackgroundColor

    width: toggleSize;
    height: isWizardButton ? toggleSize *0.2: toggleSize*0.55
    radius: toggleSize/3
    color: toggled? buttonOptionUnselected : buttonOptionSelected
    border.color: "#845E99"
    border.width: 1

    Rectangle {
        anchors.left:parent.left
        anchors.leftMargin: isWizardButton ? 0: toggleSize*0.1
        visible:!toggled
        color: !toggled ? buttonOptionUnselected : buttonOptionSelected
        anchors.verticalCenter : parent.verticalCenter
        width: toggleSize * 0.4; height: toggleSize * 0.4
        z:1
        radius:toggleSize/5
    }

    Rectangle {
        anchors.right:parent.right
        anchors.rightMargin: isWizardButton ? 0: toggleSize*0.1
        anchors.verticalCenter : parent.verticalCenter
        color: !toggled? buttonOptionUnselected : buttonOptionSelected
        visible:toggled
        width: toggleSize * 0.4; height: toggleSize * 0.4
        z:1
        radius:toggleSize/5
    }
    function toggle() {
        if(toggled)
            toggled = false;
        else toggled = true;
    }

    MouseArea {
        anchors.fill: parent
        z:1
        visible: true
        enabled: true
        onClicked: toggle()
    }
}
