import QtQuick 2.5
import QtQuick.Layouts 1.2

//TODO: why is this necessary?!
import com.viavi.style 1.0

Item {
    property string leftText: 'Left/off'
    property string rightText: 'Right/on'
    property font optionFont: ViaviStyle.layout.activeTextFont
    property color optionSelected: ViaviColor.activeColor
    property color optionUnselected: ViaviColor.disabledItemColor

    property alias button: button
    property alias hasMiddleState: button.hasMiddleState
    property alias fixedState: button.fixedState
    property alias state: button.state

    //TODO - remove isRightDataVisible after complementary change to Fiber Optics is merged
    property alias isRightDataVisible: button.isRightDataVisible

    implicitWidth: elements.width
    implicitHeight: elements.height


    RowLayout {
        id: elements
        anchors.verticalCenter: parent.verticalCenter
        FontMetrics {
            id: metricsHelper
            font: optionFont
        }

        Text {
            id: leftOption
            text: leftText
            font: optionFont
            color: button.isLeftStateActive ? optionSelected : optionUnselected
        }

        ThreeStateButton {
            id: button
            Layout.topMargin: ViaviStyle.layout.smallMargin
            Layout.bottomMargin: ViaviStyle.layout.smallMargin
            Layout.fillHeight: true
            toggleSize: metricsHelper.height * 5

            //Extend the ThreeStateButton mouse area over this entire layout
            mouseArea.anchors.leftMargin: - button.x
            mouseArea.anchors.rightMargin: (button.x + button.width) - elements.width
        }

        Text {
            id: rightOption
            text: rightText
            font: optionFont
            color: button.isRightStateActive ? optionSelected : optionUnselected
        }
    }

}
