import QtQuick 2.5
import QtQuick.Controls 2.0

import com.viavi.style 1.0

MenuItem {
    id: root
    property bool activeHighlight: false

    implicitHeight: ViaviStyle.layout.buttonHeight
    implicitWidth: implicitHeight * 4
    height: implicitHeight
    width: implicitWidth

    background: Rectangle {
        anchors.fill: parent
        color: getBackgroundColor()
        border.color: ViaviColor.borderColor
        border.width: ViaviStyle.layout.borderSmallWidth
        function getBackgroundColor() {
            return activeHighlight ? ViaviStyle.colors.activeColor:
                       (highlighted ? ViaviStyle.colors.menuSelectionColor : ViaviStyle.colors.contentBackgroundColor)
        }
    }

    contentItem: Text {
        text: root.text
        color: activeHighlight ? ViaviColor.activeItemTextColor : ViaviColor.mainInfoColor
        font: ViaviStyle.layout.activeBoldTextFont
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }
}
