import QtQuick 2.0
import QtQuick.Controls 2.1
import QtQuick.Layouts 1.2

import com.viavi.style 1.0


ColumnLayout {
    property alias title: titleLabel.text
    default property alias contentChildren: mainContentItem.contentChildren
    property bool plied: false
    property alias leftPadding: mainContentItem.leftPadding
    property alias rightPadding: mainContentItem.rightPadding
        
    MouseArea {
        Layout.fillWidth: true
        implicitWidth: titleLayout.implicitWidth
        implicitHeight: titleLayout.implicitHeight
        RowLayout {
            id: titleLayout
            Image {
                sourceSize.height: titleLabel.implicitHeight * 1.5 //A bit larger than the text to make it more visible.
                id: indicator
                source: ViaviStyle.images.iconNavigateRight
                transform: Rotation {
                    origin.x: indicator.width/2
                    origin.y: indicator.height/2
                    angle: plied ? 0:90
                }
            }
            Label {
                id: titleLabel
                font: ViaviStyle.layout.mediumBoldFont
                color: ViaviStyle.colors.activeColor
            }
        }
        onClicked: { plied = !plied }
    }
    Pane {
        Layout.fillWidth: true
        id: mainContentItem
        topPadding: 0
        visible: !plied
        contentItem: ColumnLayout { }
    }
}
