import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import com.viavi.style 1.0

Button {

    id: button

    property alias name: textComponent.text
    property string pageQmlDir: ''
    property string pageQmlName: ''
    property bool selected: parent.selectedPageButton === button

    property string fullPageQmlPath: pageQmlDir + pageQmlName
    property color unselectedColor: ViaviStyle.colors.secondaryInfoColor
    property bool centerContent: false

    visible: true
    enabled: true

    hoverEnabled: true
    background: Rectangle {
        implicitHeight: ViaviStyle.layout.buttonHeight
        color: hovered ? ViaviStyle.colors.selectedBackgroundColor : ViaviStyle.colors.pageBackgroundColor
    }

    //Note: this construction would be better served by a RowLayout
    implicitWidth: textComponent.implicitWidth + verticalLine.width + 2 * padding + ViaviStyle.layout.largeMargin + ViaviStyle.layout.smallMargin

    contentItem: Text {
        id: textComponent

        height: contentHeight
        color: enabled || selected ? ViaviStyle.colors.activeColor : unselectedColor

        elide: Text.ElideRight

        font: button.selected ? ViaviStyle.layout.largeBoldFont : ViaviStyle.layout.largeFont
        verticalAlignment: Text.AlignVCenter
        anchors.horizontalCenter: centerContent ? parent.horizontalCenter : undefined
        anchors.left: centerContent ? undefined : parent.left
        anchors.leftMargin: ViaviStyle.layout.largeMargin
        anchors.verticalCenter: parent.verticalCenter
        anchors.bottom: parent.bottom
    }


    Rectangle {
        id: verticalLine

        width: 2 * ViaviStyle.layout.borderSize
        height: textComponent.height
        anchors.left: parent.left
        anchors.leftMargin: ViaviStyle.layout.smallMargin
        anchors.horizontalCenter: centerContent ? parent.horizontalCenter : undefined
        color: ViaviStyle.colors.activeColor
        visible: selected
    }

    onClicked:{
        parent.selectedPageButton = button //TODO - can this type of reference to the parent be avoided?
    }

}
