﻿import QtQuick 2.3
import QtQuick.Controls 2.0

import com.viavi.style 1.0

AbstractButton{
    id: button

    property alias source: image.source
    property alias color: image.color
    property bool isChecked: false
    property alias mirrorImage: image.mirror
    property alias fillMode: image.fillMode

    width: ViaviStyle.layout.imageButtonHeight
    height: ViaviStyle.layout.imageButtonHeight

    contentItem:
    ColorImage{
        id: image

        width: parent.width - button.leftPadding - button.rightPadding
        height: parent.height - button.topPadding - button.bottomPadding

        color: button.enabled
                    ? button.pressed ? ViaviColor.selectedColor :
                    button.isChecked ? ViaviColor.checkedItemColor :ViaviColor.activeColor
                    : ViaviColor.disabledItemColor
    }
}
