import QtQuick 2.7
import QtQuick.Controls 2.0
import QtGraphicalEffects 1.0

import com.viavi.style 1.0

CheckBox {
    id:c1
    implicitWidth: contentItem.implicitWidth
    implicitHeight: contentItem.implicitHeight
    spacing: 3
    leftPadding: 3

    indicator: Rectangle {
        implicitWidth: implicitHeight
        implicitHeight: ViaviStyle.layout.defaultButtonHeight
//        height: implicitHeight
//        width: implicitWidth
        x: c1.leftPadding
        y: c1.height / 2 - height / 2
        radius: 3
        border.color: enabled ? "black" : ViaviStyle.colors.disabledItemColor
        ColorImage {
            id: checkIndicator
            fillMode: Image.PreserveAspectFit
            width: parent.height /2
            height: parent.height /2
            x: parent.height / 4
            y: parent.height / 4
            source: "/acterna/storage/look-and-feel/generic/checkmark.png"
            visible: c1.checked
            color: c1.enabled ? ViaviStyle.colors.black : ViaviStyle.colors.disabledItemColor
        }
    }
    contentItem: Text {
        text: c1.text
        font: c1.font
        color: "white"
        verticalAlignment: Text.AlignVCenter
        leftPadding: c1.indicator.width + c1.spacing
    }
}
