import QtQuick 2.9

import com.viavi.style 1.0

//NOTE: QtObject cannot have FontMetrics as default property
Item {

    property bool isSmallScreen: false

    readonly property int defaultScreenWidth: 1280
    readonly property int defaultScreenHeight: 800

    property int screenWidth: defaultScreenWidth
    property int screenHeight: defaultScreenHeight
	
	property bool isLandscapeMode: screenWidth > screenHeight

    function getDynamicScaleFactor() {

        if(isLandscapeMode){
            var xScale = 1.0 * screenWidth / defaultScreenWidth
            var yScale = 1.0 * screenHeight / defaultScreenHeight
        }else{
            var xScale = 1.0 * screenWidth / defaultScreenHeight
            var yScale = 1.0 * screenHeight / defaultScreenWidth
        }

        return Math.min(xScale, yScale)
    }
    //calculated dynamically if the expected screen size differes from the actuall screen size
    readonly property real dynamicScaleFactor: getDynamicScaleFactor()

    //this can be changed when create a new instance of the layout for a new resolution
    property real staticScaleFactor: 1.0

    //scale factor
    //can be used as a quick generic way to scale default sizes needed for other resolution - fonts size, component width/height
    property real scaleFactor: dynamicScaleFactor * staticScaleFactor


    // The font family used for all the fonts
    property string fontFamily: "DejaVu Sans"

    // Font sizes
    property int minuteFontSize: 12 * scaleFactor
    property int smallFontSize: 13 * scaleFactor
    property int mediumFontSize: 16 * scaleFactor
    property int largeFontSize: 19 * scaleFactor
    property int veryLargeFontSize: 22 * scaleFactor

    property int traceUnitFontSize: 18 * scaleFactor

    // Helper function to create fonts
    function getFont(fontSize, isBold)
    {
        return Qt.font({ pixelSize: fontSize, family: fontFamily, bold: isBold });
    }

    // Available font objects
    property font minuteFont: getFont(minuteFontSize, false)
    property font minuteBoldFont: getFont(minuteFontSize, true)
    property font smallFont: getFont(smallFontSize, false)
    property font smallBoldFont: getFont(smallFontSize, true)
    property font mediumFont: getFont(mediumFontSize, false)
    property font mediumBoldFont: getFont(mediumFontSize, true)
    property font largeFont: getFont(largeFontSize, false)
    property font largeBoldFont: getFont(largeFontSize, true)
    property font veryLargeFont: getFont(veryLargeFontSize, false)
    property font veryLargeBoldFont: getFont(veryLargeFontSize, true)

    property alias largeBoldFontMetrics: largeBoldFontMetricsId
    FontMetrics {
        id: largeBoldFontMetricsId
        font: largeBoldFont
    }


    // Default fonts for different components
    property font textFont: mediumFont
    property font textBoldFont: mediumBoldFont
    property font titleFont: largeBoldFont

    // Value to be used for margins and spacing
    property int smallMargin: 5 * scaleFactor
    property int mediumMargin: 10 * scaleFactor
    property int largeMargin: 20 * scaleFactor
    property int veryLargeMargin: 40 * scaleFactor

    // Border widths
    property int borderWidth: 2 * scaleFactor

    // Default component sizes
    property int defaultButtonWidth: 100
    property int defaultButtonHeight: 20
    property int defaultTextFieldWidth: 300


    // fonts logic
    // sort of alias to the basic fonts with the posibility to the "basic" font that is based upon in diffrent Style files.

    property font headerFont: largeBoldFont //table header font
    property font tableFont: veryLargeFont //table cell font
    property font tableTitleFont: largeBoldFont
    property font cursorInfoFont: mediumFont
    property font cursorImportantFont: mediumBoldFont
    property alias cursorInfoFontMetrics: cursorInfoFontMetricsId

    FontMetrics {
        id: cursorInfoFontMetricsId
        font: cursorInfoFont
    }


    property font infoTextFont: smallFont //generic information, non interactable component
    property font activeTextFont: mediumFont //active items: buttons/toggles ...
    property alias activeTextFontMetrics: activeTextFontMetricsId
    property font activeBoldTextFont: mediumBoldFont //active items: buttons/toggles ...


    FontMetrics {
        id: activeTextFontMetricsId
        font: activeTextFont
    }

    property font titleTextFont: largeBoldFont

    //fonts metrics
    property alias headerFontMetrics: headerFontMetricsId
    property alias tableFontMetrics: tableFontMetricsId
    property alias titleTextFontMetrics: titleTextFontMetricsId

    FontMetrics {
        id: headerFontMetricsId
        font: headerFont
    }

    FontMetrics {
        id: tableFontMetricsId
        font: tableFont
    }

    FontMetrics {
        id: titleTextFontMetricsId
        font: titleTextFont
    }

    // specific fonts
    property int keyboardTextFontSize: 23 * scaleFactor
    property font keyboardTextFont: getFont(keyboardTextFontSize, false)
    property alias keyboardTextFontMetrics: keyboardTextFontMetricsId

    FontMetrics {
        id: keyboardTextFontMetricsId
        font: keyboardTextFont
    }

    property int separatorSize: 1
    property int borderSize: Math.max(1, 2 * scaleFactor)
    property int borderSmallWidth: 1

    property int buttonHeight: 50 * scaleFactor
    property int buttonWidth: 200 * scaleFactor
    property int imageButtonHeight: buttonHeight
    property real tableColumnImageScale: 0.85
    property int keyboardButtonHeight: 80 * scaleFactor
    property int keyboardAlphaButtonWidth: 75 * scaleFactor
    property int keyboardNumericButtonWidth: 90 * scaleFactor

    /* Menu dimensions. Standard popup/tree type of menu, as used in OTDR Setup*/
    property int menuLineHeight: 45 * scaleFactor
    property int softKeysWidth: 2 * buttonHeight
    property int keyboardButtonMargin: 3 //TODO scale, but first verify if it's really needed
    property int dragableSeparatorWidth: 4 * buttonHeight
    property int pictogramEventSize: 40 * scaleFactor
    property int menuTextFieldWidth: 4 * menuLineHeight
    property int menuTextFieldWidthLarge: 1.5 * menuTextFieldWidth + ViaviStyle.layout.mediumMargin
    property int menuTextFieldWidthVeryLarge: 2 * menuTextFieldWidth + ViaviStyle.layout.mediumMargin
    property int menuTitleWidthSmall: 3 * menuLineHeight
    property int menuTitleWidth: 4 * menuLineHeight
    

    /* Style of menu that uses pages, as used in new OTDR Setup */
    property int setupMenuLineHeight: 50 * scaleFactor //Will change based on usability tests

}
