import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0

AbstractButton{
    id: button

    property alias textHorizontalAlignment: textId.horizontalAlignment
    property string source: FiberStyle.images.iconSettings
    font: ViaviStyle.layout.tableFont

    contentItem: Rectangle{
        color: button.enabled ? button.pressed ? ViaviStyle.colors.checkedItemColor
                                               : ViaviStyle.colors.contentBackgroundColor
                                               : ViaviStyle.colors.disabledItemColor

        border.color: ViaviStyle.colors.activeColor
        border.width: ViaviStyle.layout.borderSize * 3

        Text{
            id: textId

            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.left: parent.left
            anchors.right: icon.left
            anchors.leftMargin: ViaviStyle.layout.largeMargin
            anchors.rightMargin: ViaviStyle.layout.largeMargin

            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter

            text: button.text
            font: button.font
            elide: Text.ElideLeft
            color: button.pressed ? ViaviStyle.colors.activeColor : ViaviStyle.colors.mainInfoColor
        }

        ColorImage {
            id: icon

            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layout.largeMargin

            source: button.source

            color: ViaviStyle.colors.activeColor
            //button.pressed ? ViaviStyle.colors.activeItemTextColor: ViaviStyle.colors.activeColor

            fillMode: Image.PreserveAspectFit
            smooth: true
        }
    }
}

