import QtQuick 2.3
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0

Item{
    id: rootItem
    width: column.width
    height: column.height

    default property alias rowData: rowId.data

    signal clicked

    MouseArea{
        id: mouseAreaId
        anchors.fill: parent

        onClicked:{
            rootItem.clicked()
        }
    }

    Column {
        id: column

        spacing: ViaviStyle.layout.mediumMargin

        //invisible item to center the row inside the column
        Item{
            height: ViaviStyle.layout.separatorSize
            width: 1
        }

        Row{
            id:rowId
        }

        HorizontalSeparator{
            anchors.left: parent.left
            anchors.right: parent.right
        }
    }

    Rectangle{
        visible: mouseAreaId.pressed

        anchors.fill: parent

        color: ViaviStyle.colors.transparentBackgroundColor
    }
}
