import QtQuick 2.3

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import '..'

Item {

    id: rootItem
 
    height : valueTextId.height
    
    property alias valueText: valueTextId.text
    property alias valueColor: valueTextId.color
    property alias valueFont: valueTextId.font
    property alias valueTextHorizontalAllignment : valueTextId.horizontalAlignment 
    property alias valueTextVerticalAlignment : valueTextId.verticalAlignment

    property bool filter: false
    property bool canFilter: false

    Text{
	    id: valueTextId

	    anchors.left: parent.left
	    anchors.right: parent.right
	    
        color: ViaviStyle.colors.mainInfoColor
        font: ViaviStyle.layout.headerFont
    }

    MouseArea{
        id: mouseAreaId

        enabled: canFilter

        anchors.fill: parent

        onClicked:{
            filter = !filter;
        }
    }

    ColorImage{
        width: parent.height
        height: parent.height

        anchors.right: parent.right

        source: filter ? FiberStyle.images.filterIcon : FiberStyle.images.filterIconEmpty

        color: ViaviStyle.colors.selectedColor

        visible: canFilter
    }

    Rectangle{
        visible: mouseAreaId.pressed

        anchors.fill: parent

        color: ViaviStyle.colors.transparentBackgroundColor
    }
}
