import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQml 2.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0

import com.viavi.style.components.virtualkeyboard 1.0

Rectangle {

    id: keyboard

    width: keyboardUtils.widthAlphaKeyb
    height: keyboardUtils.heightAlphaKeyb

    x: keyboardUtils.xAlphaKeyb
    y: keyboardUtils.yAlphaKeyb

    color: ViaviColor.alternativeBackgroundColor

    property alias initialText: keyboardText.initialText
    property alias textField: keyboardText.textField
    property alias titleDescription: keyboardText.titleDescription
    property alias titleText: keyboardText.titleText
    property alias hasTitleAction: keyboardText.hasTitleAction
    property alias inputTextMaxLength: keyboardText.inputTextMaxLength
    
    signal titleClicked()
    signal canceled()
    signal accepted()
    signal inputTextChanged(string newText)

    onTitleClicked: {
        keyboard_act_handleTitleCallback.invoke()
    }

    onInputTextChanged: keyboard_cfg_text.value = newText

    onCanceled: {
        keyboard_act_handleCancelKey.invoke()
    }

    onAccepted: {
        keyboard_act_handleEnterKey.invoke()
    }

    function customButtonClicked( button )
    {
        switch ( button )
        {
        case "Cancel":
            keyboard.canceled()
            break;
        default:
            break
        }
    }

    Column{
        anchors.left: parent.left
        anchors.right: parent.right

        KeyboardCustomButton {
            buttonLabel: "Cancel"
            buttonIsCommon: true
            buttonHasPicture: true
            buttonPicturePath: keyboardUtils.buttonIconPath + "Wizard_Icon_Clear.png"
        }

        Item{

            anchors.left: parent.left
            anchors.right: parent.right
            height: keyboardText.height
            
            KeyboardHeader { 
                id: keyboardText

                titleText: keyboard_res_title.value
                hasTitleAction: keyboard_res_hasTitleCallback.value
                titleDescription : keyboard_res_titleDescription.value

                initialText: keyboard_res_initText.value
                inputTextMaxLength: keyboard_res_maxSize.value
                

                onTitleClicked: keyboard.titleClicked()
                onInputTextChanged: keyboard.inputTextChanged(newText)
                onInputTextAccepted: keyboard.accepted()
            }
        }
    }
}



