import QtQuick 2.5
import QtQuick.Layouts 1.3
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0

//TODO: cleanly merge with FiberListDelegate
Rectangle {
    id: root

    property bool isSelected
    property alias text: textId.text
    property string iconPath: ''
    signal clicked()

    height: ViaviStyle.layout.buttonHeight

    color: isSelected ? ViaviStyle.colors.activeColor: ViaviStyle.colors.contentBackgroundColor

    ColorImage {
        id: icon
        visible: iconPath.length > 0
        width: visible ? parent.height : 0
        fillMode: Image.PreserveAspectFit
        source: iconPath
        mipmap: true
        anchors.verticalCenter: parent.verticalCenter
        anchors.right: centerMarker.left
        color:  isSelected ?  ViaviStyle.colors.activeItemTextColor : "transparent"
    }

    Item {
        id: centerMarker
        width: ViaviStyle.layout.largeMargin
        anchors.centerIn: parent
    }

    Text {
        id: textId
        font: ViaviStyle.layout.activeBoldTextFont
        color: isSelected ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.mainInfoColor
        anchors.verticalCenter: parent.verticalCenter
        anchors.left: centerMarker.right
    }


    MouseArea {
        anchors.fill: parent
        onClicked: {
            root.clicked()
        }
    }
}
