#!/bin/bash

function enable_autoip {
  MAC=$(ifconfig eth0 | grep ether | tr -s [:blank:] | tr [A-Z] [a-z] | cut -d ' ' -f 3)
  
  echo "enabling autoip"
  echo "mac address for eth0 equals " $MAC
  
  NET_PATH="/var/lib/avahi-autoipd/$MAC"
  
  echo "file to read" $NET_PATH
  IP=$(cat $NET_PATH)
  echo "new ip is" $IP
  
  ifconfig eth0:jdsu inet $IP netmask 255.255.0.0 broadcast 169.254.255.255
  scpi "SYSTEM:ETHERNET:AUTOIP \"$IP\""
}

function disable_autoip {
  echo "disable autoip"
  ifconfig eth0:jdsu down
}

function usage {
   echo "usage: ./network.sh [-e|-d]"
   exit -1
}

if [ $# == 0 ]; then
  usage
fi

while getopts "ed" opt; do
   case $opt in
      e)
         enable_autoip
	 ;;
      d)
	 disable_autoip
	 ;;
      \?)
         usage
         ;;
   esac
done

exit 0
