import QtQuick 2.3
import libfo 1.0

import com.viavi.style 1.0
import com.viavi.fiberutilui.components 1.0
import com.viavi.fiberutilui.Util_Ui_Qt 1.0
import com.viavi.style.components.virtualkeyboard 1.0

Rectangle {
    width: 500
    height: 400

    border.width: 2
    border.color: ViaviStyle.colors.secondaryInfoColor
    color: ViaviStyle.colors.white

    property int items_margin: 10
    property int scrollbar_width: 5
    property real ratio_taille_popup_ratio: 5.0/6.0
    property int alinea_subline: title.width / 16
    

    // members
    property int selected_ratio_opened : -1;

    function onOKRatio(value)
    {
        if( selected_ratio_opened >= 0  )
        {
            platform.getElfData(":config:Fiber_Optic:wizardSetupData:splitterRatioSelectedRatio:" + selected_ratio_opened + ":").value = value
            wizardSetupData_act_splitterValidateRatio.invoke()
            selected_ratio_opened = -1;
        }
        listSelection.btnOkClicked.disconnect(onOKRatio);
    }

    function onNOKRatio(value)
    {
        wizardSetupData_act_splitterRestoreRatio.invoke()
        selected_ratio_opened = -1;
        listSelection.btnCancelClicked.disconnect(onNOKRatio);
    }

    property bool warningOnScreen: (popUpProgress_LaunchCable.visible || measPopUp.visible)
    
    Rectangle {
        id: title
        width: parent.width
        height: 30
        color: ViaviStyle.colors.secondaryInfoColor
        anchors.top : parent.top
        
        visible: false
        
        Text {
            id: titleTxt
            width: parent.width / 2
            height: parent.height

            wrapMode: Text.Wrap
            color: ViaviStyle.colors.white
            text: wizardWindowManager_res_txtTitleSetupWindow.value
            font.pixelSize: 20
            horizontalAlignment: Text.AlignLeft
            verticalAlignment:  Text.AlignVCenter
        }
     }

    Flickable
    {
        id: flickableContainer
        enabled: !(keypad.visible || listSelection.visible || warningOnScreen)

        anchors.left: parent.left
        anchors.leftMargin: items_margin
        anchors.right: parent.right
        anchors.rightMargin: items_margin + indicatorFlickable.width
        anchors.top: parent.top
        anchors.topMargin: items_margin
        anchors.bottom: buttonSelection.top
        anchors.bottomMargin: items_margin
        
        clip: true
        boundsBehavior: Flickable.StopAtBounds
        interactive: contentHeight >  height
        
        contentHeight: lineContainer.height
        
        onContentYChanged: {
            indicatorFlickable.value = parseInt(contentY, 10) * 100 / flickableContainer.contentHeight;
        }
        
        onHeightChanged: indicatorFlickable.ratio = (indicatorFlickable.height + items_margin)  * 100 / (flickableContainer.contentHeight);
        onContentHeightChanged: indicatorFlickable.ratio = (indicatorFlickable.height + items_margin)  * 100 / (flickableContainer.contentHeight);

        contentY: parseInt(indicatorFlickable.value * flickableContainer.contentHeight / 100 , 10)

        Item {
            id: lineContainer

            height: columnContainer.height + items_margin
            width: parent.width - 2 * items_margin
            
            Column {
                id: columnContainer
                spacing: items_margin
                width: parent.width
                
                property real sublineWidth: ( width / 3 -  2 * items_margin )

               Wizard_Setup_Message_Box_Line {
                    id: testFeatureChoice

                    visible: wizardSetupData_res_testFeatureIsVisible.value

                    inputText:  wizardSetupData_res_testFeatureItemHeader.value
                    inputModel: wizardSetupData_res_testFeatureList.value
                    isExclusive: true
 
                    onSelectValueChanged: wizardSetupData_act_handleTestFeatureSelection.invokeWithStringArg( index )
                }
                
                Wizard_Setup_Message_Box_Line {
                    id: laserChoice

                    visible: wizardSetupData_res_laserIsVisible.value && !wizardSetupData_res_isDwdm.value

                    inputText:  wizardSetupData_res_laserItemHeader.value
                    inputModel: wizardSetupData_res_laserList.value
                    isExclusive: wizardSetupData_res_laserIsExclusive.value
                    isError: !wizardSetupData_res_isLaserAvailable.value

                    onSelectValueChanged: wizardSetupData_act_handleLaserIndexSelection.invokeWithStringArg( index )
                }
                
                Rectangle {
                    width: parent.width
                    height: 60

                    color: "transparent"

                    visible: wizardSetupData_res_dwdmIsVisible.value && wizardSetupData_res_isDwdm.value

                    Wizard_Setup_Message_Box_Line {
                        id: dwdmUnitChoice 
                        
                        anchors.left: parent.left
                        anchors.right: subLineDwdmLaserChoice.left
                        anchors.rightMargin: 2
                        
                        inputText:  wizardSetupData_res_dwdmItemHeader.value
                        inputModel: wizardSetupData_res_dwdmUnitList.value
                        isExclusive: wizardSetupData_res_dwdmIsExclusive.value
                        
                        onSelectValueChanged: wizardSetupData_cfg_dwdmUnitSelection.value = index
                    }
	                
	                Wizard_Setup_Message_Box_SubLine {
	                     id: subLineDwdmLaserChoice
						 width: columnContainer.sublineWidth
						 headerVisible: false
	
	                     anchors.right: parent.right
	
                         inputText: wizardSetupData_res_dwdmSubLineHeader.value
                         outputValue: wizardSetupData_res_dwdmSubLineValue.value
	                     enableSelection: wizardSetupData_res_testFeatureSelection.value != wizardSetupData_res_testFeatureSelection.enums.ecTestFeat_Wavescan

                   function onOKDwdmLaser(idx)
                      {
                     wizardSetupData_cfg_dwdmListPosition.value = idx;
                  	 listSelection.btnOkClicked.disconnect(onOKDwdmLaser);
                      }
                      
                   function onNOKDwdmLaser(idx)
                      {
                  	 listSelection.btnCancelClicked.disconnect(onNOKDwdmLaser);
                      }

	                    onOpenEditorClicked: {
                            listSelection.titleText = wizardSetupData_res_dwdmSubLineHeader.value
                            listSelection.model = wizardSetupData_res_dwdmLaserList.value
                            listSelection.currentIndex = wizardSetupData_cfg_dwdmListPosition.value
                            listSelection.btnOkClicked.connect(onOKDwdmLaser);
					        listSelection.btnCancelClicked.connect(onNOKDwdmLaser);

                            listSelection.open()
	                    }
	                }
                }


                Wizard_Setup_Message_Box_Line {
                    id: directionChoice

                    visible: wizardSetupData_res_directionIsVisible.value

                    inputText:  wizardSetupData_res_directionItemHeader.value
                    inputModel: wizardSetupData_res_directionList.value
                    isExclusive: wizardSetupData_res_directionIsExclusive.value

                    onSelectValueChanged: wizardSetupData_cfg_directionSelection.value = index
                }


                Rectangle {
                    width: parent.width
                    height: wizardSetupData_res_splitterIsRatioVisible.value ? 60 * 2 + items_margin : 60
                    color: "transparent"

                    visible: wizardSetupData_res_splitterIsVisible.value

                    Wizard_Setup_Message_Box_Line {
                        id: splittersChoice
                        width: parent.width
                        inputText:  wizardSetupData_res_splitterItemHeader.value
                        inputModel: wizardSetupData_res_splitterOptionsList.value
                        isExclusive: wizardSetupData_res_splitterIsExclusive.value

                        onSelectValueChanged: wizardSetupData_cfg_splitterSelection.value = index
                    }



                    Row {
                        id: splitters_ratio
                        anchors.left: parent.left
                        anchors.right: parent.right
                        anchors.top: splittersChoice.bottom
                        anchors.topMargin: items_margin
                        spacing: items_margin
                        
                        visible: wizardSetupData_res_splitterIsRatioVisible.value

                        Rectangle {
                            id: ont
                            width: alinea_subline / 2
                            height: splitters_ratio.height
                            color: ViaviStyle.colors.secondaryInfoColor
                            anchors.verticalCenter: parent.verticalCenter
                            Text {
                                text: wizardWindowManager_res_txtOLTHeader.value
                                font.pixelSize: 18
                                color: ViaviStyle.colors.white
                                anchors.centerIn: parent
                                rotation: -90
                                transformOrigin: Item.Center
                                verticalAlignment: Text.AlignVCenter
                                horizontalAlignment: Text.AlignHCenter
                            }

                        }
                        Repeater {
                            model: wizardSetupData_res_splitterRatiosList.value
                            
                            Wizard_Setup_Message_Box_SubLine {
                                id: subLineSplitter1
                                width:  ( splitters_ratio.width - 2 * items_margin - alinea_subline - 2 * items_margin ) / 3;
                                inputText: model.ratioName
                                outputValue: model.ratioSelectedName
                                enableSelection: model.ratioVisible
                                headerVisible: true
                                
                                onOpenEditorClicked: {
                                    selected_ratio_opened = index;
                                    listSelection.titleText = wizardWindowManager_res_txtLoadRatioHeader.value
                                    listSelection.model = platform.getElfData(":result:Fiber_Optic:wizardSetupData:splitterRatioOptionList:" + index + ":").value
                                    listSelection.currentIndex = platform.getElfData(":config:Fiber_Optic:wizardSetupData:splitterRatioSelectedRatio:" + index + ":").value
                                    listSelection.btnOkClicked.connect(onOKRatio);
                                    listSelection.btnCancelClicked.connect(onNOKRatio);

                                    listSelection.open()
                                }
                            }
                        }
                        Rectangle {
                            id: olt
                            width: alinea_subline / 2
                            height: splitters_ratio.height
                            color: ViaviStyle.colors.secondaryInfoColor
                            anchors.verticalCenter: parent.verticalCenter
                            Text {
                                text: wizardWindowManager_res_txtONTHeader.value
                                font.pixelSize: 18
                                color: ViaviStyle.colors.white
                                anchors.centerIn: parent
                                rotation: 90
                                transformOrigin: Item.Center
                                verticalAlignment: Text.AlignVCenter
                                horizontalAlignment: Text.AlignHCenter
                            }
                        }
                    }
                }
                Wizard_Setup_Message_Box_Line {
                    id: distanceUnitChoice

                    visible: wizardSetupData_res_unitsIsVisible.value

                    inputText:  wizardSetupData_res_unitsItemHeader.value
                    inputModel: wizardSetupData_res_unitsList.value
                    isExclusive: wizardSetupData_res_unitsIsExclusive.value

                    onSelectValueChanged: wizardSetupData_cfg_unitsCurrentSelection.value = index
                }

                Rectangle {
                    width: parent.width
                    height: 60

                    color: "transparent"

                    visible: wizardSetupData_res_launchCableIsVisible.value

                    Wizard_Setup_Message_Box_Line {
                        id: launchCableChoice
                        
                        anchors.left: parent.left
                        anchors.right: subLineLaunchCableChoice.left
                        anchors.rightMargin: 2

                        inputText:  wizardSetupData_res_launchCableItemHeader.value
                        inputModel: wizardSetupData_res_launchCableYesNoList.value
                        isExclusive:  wizardSetupData_res_launchCableIsExclusive.value

                        onSelectValueChanged: wizardSetupData_cfg_launchCableYesNoSelection.value = index
                    }

                    Wizard_Setup_Message_Box_SubLine {
                        id: subLineLaunchCableChoice
                        width: columnContainer.sublineWidth
                        anchors.right: parent.right

                        visible: wizardSetupData_res_launchCableSubLineIsEnabled.value

                        inputText: wizardSetupData_res_launchCableSubLineHeader.value
                        outputValue: wizardSetupData_cfg_launchCableSubLineValue.value
                        enableSelection: wizardSetupData_res_launchCableSubLineIsEnabled.value
                        
                        function editNumber(txtOutput, validation) {   
						         if (validation === true)
						            {
                                     wizardSetupData_cfg_launchCableSubLineValue.value = txtOutput;
						            }        
						    
						         keypad.editText.disconnect(editNumber); 
					         }

                        onOpenEditorClicked: {
                            keypad.visible = true;
                            keypad.titleText = wizardSetupData_res_launchCableItemHeader.value
                            keypad.initialText = wizardSetupData_cfg_launchCableSubLineValue.value
                            keypad.minValue = wizardSetupData_res_launchCableMinValue.value
                            keypad.maxValue = wizardSetupData_res_launchCableMaxValue.value
                            keypad.configurableButtonPicturePath = keyboardUtils.buttonIconPath + "Icon_Measure.png";
                            keypad.configurableButtonEnabled = wizardSetupData_res_isLaserAvailable.value
                            keypad.editText.connect(editNumber);	
                        }
                    }
                }

                Text {
                    text: wizardSetupData_res_launchCableWarning.value
                    visible: wizardSetupData_res_launchCableWarningDisplay.value
                    font.pixelSize: 18
                    color: ViaviStyle.colors.red
                    anchors.horizontalCenter: parent.horizontalCenter
                    wrapMode: Text.Wrap
                }

                Rectangle {
                    width: parent.width
                    height: 60

                    color: "transparent"

                    visible: wizardSetupData_res_receiveCableIsVisible.value

                    Wizard_Setup_Message_Box_Line {
                        id: receiveCableChoice
                        
                        anchors.left: parent.left
                        anchors.right: subLineReceiveCableChoice.left
                        anchors.rightMargin: 2

                        inputText:  wizardSetupData_res_receiveCableItemHeader.value
                        inputModel: wizardSetupData_res_receiveCableYesNoList.value
                        isExclusive: wizardSetupData_res_receiveCableIsExclusive.value

                        onSelectValueChanged: wizardSetupData_cfg_receiveCableYesNoSelection.value = index
                    }

                    Wizard_Setup_Message_Box_SubLine {
                        id: subLineReceiveCableChoice
                        width: columnContainer.sublineWidth
                        anchors.right: parent.right
                        
                        visible: wizardSetupData_res_receiveCableSubLineIsEnabled.value

                        inputText: wizardSetupData_res_receiveCableSubLineHeader.value
                        outputValue: wizardSetupData_cfg_receiveCableSubLineValue.value
                        enableSelection: wizardSetupData_res_receiveCableSubLineIsEnabled.value
                        
                        function editNumber(txtOutput, validation) {   
						         if (validation === true)
						            {
                                    wizardSetupData_cfg_receiveCableSubLineValue.value = txtOutput;
						            }        
						    
						         keypad.editText.disconnect(editNumber); 
					          }

                        onOpenEditorClicked: {
                            keypad.visible = true;
                            keypad.titleText = wizardSetupData_res_receiveCableItemHeader.value
                            keypad.initialText = wizardSetupData_cfg_receiveCableSubLineValue.value
                            keypad.minValue = wizardSetupData_res_receiveCableMinValue.value
                            keypad.maxValue = wizardSetupData_res_receiveCableMaxValue.value
                            keypad.editText.connect(editNumber);	
                            keypad.configurableButtonPicturePath = ""
                            keypad.configurableButtonEnabled = false
                        }
                    }
                }
                
                Rectangle {
                    width: parent.width
                    height: 60

                    color: "transparent"

                    visible: wizardSetupData_res_alarmsIsVisible.value

                    Wizard_Setup_Message_Box_Line {
                        id: alarmChoice
                        
                        anchors.left: parent.left
                        anchors.right: subLineAlarmChoice.left
                        anchors.rightMargin: 2

                        inputText:  wizardSetupData_res_alarmsItemHeader.value
                        inputModel: wizardSetupData_res_alarmsYesNoList.value
                        isExclusive: wizardSetupData_res_alarmsIsExclusive.value

                        onSelectValueChanged: wizardSetupData_cfg_alarmsYesNoSelection.value = index
                    }

                    Wizard_Setup_Message_Box_SubLine {
                        id: subLineAlarmChoice
                        width: columnContainer.sublineWidth

                        anchors.right: parent.right
                        
                        visible: wizardSetupData_res_alarmsSubLineIsEnabled.value

                        inputText: wizardSetupData_res_alarmsSubLineHeader.value
                        outputValue: wizardSetupData_res_alarmsSubLineValue.value
                        enableSelection: wizardSetupData_res_alarmsSubLineIsEnabled.value
                        
                        function onOKAlarm(idx) {
                                 wizardSetupData_cfg_alarmsListPosition.value = idx;
					             listSelection.btnOkClicked.disconnect(onOKAlarm);
					         }
					    
					         function onNOKAlarm(idx) {
					             listSelection.btnCancelClicked.disconnect(onNOKAlarm);
					         }
                        
                        onOpenEditorClicked: {
                            listSelection.titleText = wizardWindowManager_res_txtLoadAlarmHeader.value
                            listSelection.model = wizardSetupData_res_alarmsThresholdList.value
                            listSelection.currentIndex = wizardSetupData_cfg_alarmsListPosition.value;
                            listSelection.btnOkClicked.connect(onOKAlarm);
   					        listSelection.btnCancelClicked.connect(onNOKAlarm);    
                            listSelection.open()
                        }
                    }
                }
            }
        }

    }
    
    ViaviSlider {
        id: indicatorFlickable
        width: (visible == true) ? scrollbar_width : 0
        orientation : Qt.Vertical

        anchors.right: parent.right
        anchors.rightMargin: items_margin

        anchors.top: flickableContainer.top
        anchors.topMargin: items_margin / 2
        anchors.bottom: flickableContainer.bottom
        anchors.bottomMargin: items_margin / 2

        visible: flickableContainer.contentHeight >  flickableContainer.height

        ratio: (indicatorFlickable.height + items_margin)  * 100 / (flickableContainer.contentHeight)
    }

    Wizard_Setup_Message_Box_Button {
        id: buttonSelection
        anchors.bottom: parent.bottom
        
        width: parent.width
        height: 70

        enabled: !(keypad.visible || listSelection.visible || warningOnScreen)
    }



    WizardKeyboardNumerical {
        id: keypad

        KeyboardUtils { id: keyboardUtils }

        visible: false
        enabled: !warningOnScreen

        anchors.centerIn: parent
    }

    Wizard_Setup_Message_Box_Listview {
        id: listSelection

        width: parent.width
        height: parent.height
    }
    
    Wizard_Pop_Up_Warning {
    	id: measPopUp

        width: parent.width
        height: parent.height
        
        visible: ( wizardSetupData_res_launchCableDisplayMeasInfo.value || wizardSetupData_res_launchCableFailedWarning.value )
        focus: ( wizardSetupData_res_launchCableDisplayMeasInfo.value || wizardSetupData_res_launchCableFailedWarning.value )
        
        function startMeas() {
            wizardSetupData_act_launchCableMeas.invoke()
		}
		
		function cancelMeas() {
            wizardSetupData_act_launchCableCancelMeas.invoke()
			subLineLaunchCableChoice.openEditorClicked();
		}
		        
        onVisibleChanged: {
            if ( wizardSetupData_res_launchCableDisplayMeasInfo.value )
            {
                keypad.editText.disconnect(subLineLaunchCableChoice.editNumber);
                measPopUp.warningType = "Info";
                measPopUp.titleText = ""
                measPopUp.text = wizardWindowManager_res_txtMeasLaunchCableInfo.value;
                measPopUp.userActionClose.disconnect(cancelMeas);
                measPopUp.button1Text = wizardWindowManager_res_txtConfirm.value;
                measPopUp.button1Action.connect(startMeas);
                measPopUp.button2Text = wizardWindowManager_res_txtCancel.value;
                measPopUp.exitText = ""
                measPopUp.button2Action.connect(cancelMeas);
            }
            else if ( wizardSetupData_res_launchCableFailedWarning.value )
            {
                measPopUp.warningType = "Error";
                measPopUp.titleText = wizardWindowManager_res_txtMeasLaunchCableFail.value;
                measPopUp.text = wizardWindowManager_res_txtMeasLaunchCableFail2.value;
                measPopUp.exitText = wizardWindowManager_res_txtClickToExit.value;
                measPopUp.button1Text = ""
                measPopUp.button2Text = ""
                measPopUp.button1Action.disconnect(startMeas);
                measPopUp.button2Action.disconnect(cancelMeas);
                measPopUp.userActionClose.connect(cancelMeas);
            }
            else
            {
                measPopUp.userActionClose.disconnect(cancelMeas);
                measPopUp.titleText = "";
                measPopUp.text = "";
                measPopUp.exitText = "";
                measPopUp.button1Text = ""
                measPopUp.button2Text = ""
                measPopUp.button1Action.disconnect(startMeas);
                measPopUp.button2Action.disconnect(cancelMeas);
            }
        }
    }
    
    Wizard_Pop_Up_Warning {
    	id: popUpProgress_LaunchCable
    	
        width: parent.width
        height: parent.height

    	warningType: "Progress"

        visible: wizardSetupData_res_launchCableIsMeasInProgress.value
        focus: wizardSetupData_res_launchCableIsMeasInProgress.value
		

		function stopMeas() {
            wizardSetupData_act_launchCableStopMeas.invoke()
		}
		
		onVisibleChanged: {
            if ( wizardSetupData_res_launchCableIsMeasInProgress.value )
				{
                popUpProgress_LaunchCable.text = wizardWindowManager_res_txtMeasLaunchCableProgress.value;
                popUpProgress_LaunchCable.titleText = "";
                popUpProgress_LaunchCable.button2Text = wizardWindowManager_res_txtCancel.value;
                popUpProgress_LaunchCable.button2Action.connect(stopMeas);
				}
			else
				{
                popUpProgress_LaunchCable.titleText = "";
                popUpProgress_LaunchCable.text = "";
                popUpProgress_LaunchCable.button2Action.disconnect(stopMeas);
				}
		}
		

        inProgress: wizardSetupData_res_launchCableIsMeasInProgress.value
		
		
    }
}
