import QtQuick 2.3
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0

ColumnLayout {
    id: root

    PliableControl {
        title: menuOtdr.generalPage.testConfiguration.name.text //'Test configuration'
        Layout.fillWidth: true

        ViaviMenuLineMultiOption {
            text: menuOtdr.generalPage.networkType.name.text
            model: menuOtdr.generalPage.networkType.multiOptionModel
            //NOTE: currently always shown to enable testing.
//            visible: menuOtdr.generalPage.networkType.available
//            enabled: menuOtdr.generalPage.networkType.enabled
            Layout.fillWidth: true
            onSgnOptionClicked: {
                menuOtdr.generalPage.networkType.validateOption(index)
            }
        }

        ViaviButton {
            text: menuOtdr.generalPage.loadConfiguration.name.text
            onClicked: menuOtdr.generalPage.loadConfiguration.validateValue()
        }
        Label {
            text: menuOtdr.generalPage.currentConfig.name.text + ': ' + menuOtdr.generalPage.loadConfiguration.value
        }
        ViaviButton {
            text: menuOtdr.generalPage.saveConfiguration.name.text
            onClicked: menuOtdr.generalPage.saveConfiguration.validateValue()
        }
    }


    property int gridColumnSpacing: ViaviStyle.layout.largeMargin

    PliableControl {
        id: detection
        title: menuOtdr.generalPage.detection.name.text //'Detection'
        Layout.fillWidth: true
        plied: true

        //NOTE: we're computing the size of components explicitly. Any error in their computation would triggers infinite rearangement with a GridLayout, thuse prefer Grid.
        GridLayout {
            id: detectionGrid
            columns: 2
            Layout.fillWidth: true
            columnSpacing: gridColumnSpacing

            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.splice.name.text
                textData.text: menuOtdr.generalPage.splice.value
                onTextClicked: menuOtdr.generalPage.splice.validateValue()
                visible: menuOtdr.generalPage.splice.available
                enabled: menuOtdr.generalPage.splice.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.bend.name.text
                textData.text: menuOtdr.generalPage.bend.value
                onTextClicked: menuOtdr.generalPage.bend.validateValue()
                visible: menuOtdr.generalPage.bend.available
                enabled: menuOtdr.generalPage.bend.enabled
            }

            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.reflectance.name.text
                textData.text: menuOtdr.generalPage.reflectance.value
                onTextClicked: menuOtdr.generalPage.reflectance.validateValue()
                visible: menuOtdr.generalPage.reflectance.available
                enabled: menuOtdr.generalPage.reflectance.enabled
            }

            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.slopeOnSection.name.text
                textData.text: menuOtdr.generalPage.slopeOnSection.value
                onTextClicked: menuOtdr.generalPage.slopeOnSection.validateValue()
                visible: menuOtdr.generalPage.slopeOnSection.available
                enabled: menuOtdr.generalPage.slopeOnSection.enabled
            }

            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.fiberEnd.name.text
                textData.text: menuOtdr.generalPage.fiberEnd.value
                onTextClicked: menuOtdr.generalPage.fiberEnd.validateValue()
                //visible: menuOtdr.generalPage.fiberEnd.available
                //enabled: menuOtdr.generalPage.fiberEnd.enabled
            }

            ViaviMenuLineComboBox {
                id: ghost

                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.ghost.name.text
                comboBoxData.model: menuOtdr.generalPage.ghost.multiOptionModel
                visible: menuOtdr.generalPage.ghost.available
                enabled: menuOtdr.generalPage.ghost.enabled
                comboBoxData.currentIndex: menuOtdr.generalPage.ghost.selectedIndex
                comboBoxData.onCurrentIndexChanged: {
                    menuOtdr.generalPage.ghost.validateOption(comboBoxData.currentIndex)
                }
                Connections {
                    target: menuOtdr.generalPage.ghost
                    function onSelectedIndexChanged() {
                        ghost.comboBoxData.currentIndex = menuOtdr.generalPage.ghost.selectedIndex
                    }
                }
            }
            ViaviMenuLineInputText {

                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.muxDemux.name.text
                textData.text: menuOtdr.generalPage.muxDemux.value
                onTextClicked: menuOtdr.generalPage.muxDemux.validateValue()
                visible: menuOtdr.generalPage.muxDemux.available
                enabled: menuOtdr.generalPage.muxDemux.enabled
            }
            ViaviMenuLineInputText {

                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.UBDiscover.name.text
                textData.text: menuOtdr.generalPage.UBDiscover.value
                onTextClicked: menuOtdr.generalPage.UBDiscover.validateValue()
                visible: menuOtdr.generalPage.UBDiscover.available
                enabled: menuOtdr.generalPage.UBDiscover.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.UBDropDiscover.name.text
                textData.text: menuOtdr.generalPage.UBDropDiscover.value
                onTextClicked: menuOtdr.generalPage.UBDropDiscover.validateValue()
                visible: menuOtdr.generalPage.UBDropDiscover.available
                enabled: menuOtdr.generalPage.UBDropDiscover.enabled
            }
        }
    }

    PliableControl {
        id: analysis
        title: menuOtdr.generalPage.analysis.name.text //'Analysis'
        plied: true

        ViaviMenuLineSwitch_YesNo {
            text: menuOtdr.generalPage.frontConnectorMeas.name.text
            checked: menuOtdr.generalPage.frontConnectorMeas.switch

            //TODO: make onCheckedChanged work, would be cleaner than with new signal. Same with following switches.
//            onCheckedChanged: {
//                menuOtdr.generalPage.frontConnectorMeas.validateSwitch(checked)
//            }
            onSgnSwitch: {
                menuOtdr.generalPage.frontConnectorMeas.validateSwitch(value)
            }
        }
        ViaviMenuLineSwitch_YesNo {
            text: menuOtdr.generalPage.propagationDelay.name.text
            checked: menuOtdr.generalPage.propagationDelay.switch

            onSgnSwitch: {
                menuOtdr.generalPage.propagationDelay.validateSwitch(value)
            }
        }
        ViaviMenuLineSwitch_YesNo {
            text: menuOtdr.generalPage.evtAfterEOF.name.text
            checked: menuOtdr.generalPage.evtAfterEOF.switch

            onSgnSwitch: {
                menuOtdr.generalPage.evtAfterEOF.validateSwitch(value)
            }
        }
    }

    PliableControl {
        id: indexOfRefr
        title: menuOtdr.generalPage.indexOfRefr.name.text  //'Index of refraction'
        Layout.fillWidth: true
        plied: true

        ViaviMenuLineComboBox {
            id: presetIndex
            
            comboboxWidth: ViaviStyle.layout.menuTextFieldWidthLarge

            text: menuOtdr.generalPage.presetIndex.name.text

            comboBoxData.model: menuOtdr.generalPage.presetIndex.multiOptionModel
            visible: menuOtdr.generalPage.presetIndex.available
            enabled: menuOtdr.generalPage.presetIndex.enabled
            comboBoxData.currentIndex: menuOtdr.generalPage.presetIndex.selectedIndex
            comboBoxData.onCurrentIndexChanged: {
                menuOtdr.generalPage.presetIndex.validateOption(comboBoxData.currentIndex)
            }
            Connections {
                target: menuOtdr.generalPage.presetIndex
                function onSelectedIndexChanged() {
                    presetIndex.comboBoxData.currentIndex = menuOtdr.generalPage.presetIndex.selectedIndex
                }
            }
            textWidth: ViaviStyle.layout.menuTitleWidthSmall
        }
        GridLayout {
            id: indexOfRefrGrid
            Layout.fillWidth: true
            columnSpacing: gridColumnSpacing
            columns: 2

            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.IOR_850_MM.name.text
                textData.text: menuOtdr.generalPage.IOR_850_MM.value
                onTextClicked: menuOtdr.generalPage.IOR_850_MM.validateValue()
                visible: menuOtdr.generalPage.IOR_850_MM.available
                enabled: menuOtdr.generalPage.IOR_850_MM.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall
                
                text: menuOtdr.generalPage.IOR_1300_MM.name.text
                textData.text: menuOtdr.generalPage.IOR_1300_MM.value
                onTextClicked: menuOtdr.generalPage.IOR_1300_MM.validateValue()
                visible: menuOtdr.generalPage.IOR_1300_MM.available
                enabled: menuOtdr.generalPage.IOR_1300_MM.enabled                
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.IOR_1310_SM.name.text
                textData.text: menuOtdr.generalPage.IOR_1310_SM.value
                onTextClicked: menuOtdr.generalPage.IOR_1310_SM.validateValue()
                visible: menuOtdr.generalPage.IOR_1310_SM.available
                enabled: menuOtdr.generalPage.IOR_1310_SM.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.IOR_1360_1510_SM.name.text
                textData.text: menuOtdr.generalPage.IOR_1360_1510_SM.value
                onTextClicked: menuOtdr.generalPage.IOR_1360_1510_SM.validateValue()
                visible: menuOtdr.generalPage.IOR_1360_1510_SM.available
                enabled: menuOtdr.generalPage.IOR_1360_1510_SM.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.IOR_1550_SM.name.text
                textData.text: menuOtdr.generalPage.IOR_1550_SM.value
                onTextClicked: menuOtdr.generalPage.IOR_1550_SM.validateValue()
                visible: menuOtdr.generalPage.IOR_1550_SM.available
                enabled: menuOtdr.generalPage.IOR_1550_SM.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.IOR_1625_1650_SM.name.text
                textData.text: menuOtdr.generalPage.IOR_1625_1650_SM.value
                onTextClicked: menuOtdr.generalPage.IOR_1625_1650_SM.validateValue()
                visible: menuOtdr.generalPage.IOR_1625_1650_SM.available
                enabled: menuOtdr.generalPage.IOR_1625_1650_SM.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.sectionAB.name.text
                textData.text: menuOtdr.generalPage.sectionAB.value
                onTextClicked: menuOtdr.generalPage.sectionAB.validateValue()
                visible: menuOtdr.generalPage.sectionAB.available
                enabled: menuOtdr.generalPage.sectionAB.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.linkLength.name.text
                textData.text: menuOtdr.generalPage.linkLength.value
                onTextClicked: menuOtdr.generalPage.linkLength.validateValue()
                visible: menuOtdr.generalPage.linkLength.available
                enabled: menuOtdr.generalPage.linkLength.enabled
            }
        }
    }

    PliableControl {
        id: scatterCoef
        title: menuOtdr.generalPage.scatterCoefficient.name.text //'Scatter coefficient'
        Layout.fillWidth: true
        plied: true

        ViaviMenuLineComboBox {
            id: presetScatter

            comboboxWidth: ViaviStyle.layout.menuTextFieldWidthLarge

            text: menuOtdr.generalPage.presetScatter.name.text

            comboBoxData.model: menuOtdr.generalPage.presetScatter.multiOptionModel
            visible: menuOtdr.generalPage.presetScatter.available
            enabled: menuOtdr.generalPage.presetScatter.enabled
            comboBoxData.currentIndex: menuOtdr.generalPage.presetScatter.selectedIndex
            comboBoxData.onCurrentIndexChanged: {
                menuOtdr.generalPage.presetScatter.validateOption(comboBoxData.currentIndex)
            }
            Connections {
                target: menuOtdr.generalPage.presetScatter
                function onSelectedIndexChanged() {
                    presetScatter.comboBoxData.currentIndex = menuOtdr.generalPage.presetScatter.selectedIndex
                }
            }
            textWidth: ViaviStyle.layout.menuTitleWidthSmall
        }

        GridLayout {
            id: scatterCoefGrid
            Layout.fillWidth: true
            columnSpacing: gridColumnSpacing
            columns: 2

            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.SC_850_MM.name.text
                textData.text: menuOtdr.generalPage.SC_850_MM.value
                onTextClicked: menuOtdr.generalPage.SC_850_MM.validateValue()
                visible: menuOtdr.generalPage.SC_850_MM.available
                enabled: menuOtdr.generalPage.SC_850_MM.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.SC_1300_MM.name.text
                textData.text: menuOtdr.generalPage.SC_1300_MM.value
                onTextClicked: menuOtdr.generalPage.SC_1300_MM.validateValue()
                visible: menuOtdr.generalPage.SC_1300_MM.available
                enabled: menuOtdr.generalPage.SC_1300_MM.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.SC_850_MM_62.name.text
                textData.text: menuOtdr.generalPage.SC_850_MM_62.value
                onTextClicked: menuOtdr.generalPage.SC_850_MM_62.validateValue()
                visible: menuOtdr.generalPage.SC_850_MM_62.available
                enabled: menuOtdr.generalPage.SC_850_MM_62.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.SC_1300_MM_62.name.text
                textData.text: menuOtdr.generalPage.SC_1300_MM_62.value
                onTextClicked: menuOtdr.generalPage.SC_1300_MM_62.validateValue()
                visible: menuOtdr.generalPage.SC_1300_MM_62.available
                enabled: menuOtdr.generalPage.SC_1300_MM_62.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.SC_1310_SM.name.text
                textData.text: menuOtdr.generalPage.SC_1310_SM.value
                onTextClicked: menuOtdr.generalPage.SC_1310_SM.validateValue()
                visible: menuOtdr.generalPage.SC_1310_SM.available
                enabled: menuOtdr.generalPage.SC_1310_SM.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.SC_1360_1510_SM.name.text
                textData.text: menuOtdr.generalPage.SC_1360_1510_SM.value
                onTextClicked: menuOtdr.generalPage.SC_1360_1510_SM.validateValue()
                visible: menuOtdr.generalPage.SC_1360_1510_SM.available
                enabled: menuOtdr.generalPage.SC_1360_1510_SM.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.SC_1550_SM.name.text
                textData.text: menuOtdr.generalPage.SC_1550_SM.value
                onTextClicked: menuOtdr.generalPage.SC_1550_SM.validateValue()
                visible: menuOtdr.generalPage.SC_1550_SM.available
                enabled: menuOtdr.generalPage.SC_1550_SM.enabled
            }
            ViaviMenuLineInputText {
                Layout.fillWidth: true
                mainContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.generalPage.SC_1625_1650_SM.name.text
                textData.text: menuOtdr.generalPage.SC_1625_1650_SM.value
                onTextClicked: menuOtdr.generalPage.SC_1625_1650_SM.validateValue()
                visible: menuOtdr.generalPage.SC_1625_1650_SM.available
                enabled: menuOtdr.generalPage.SC_1625_1650_SM.enabled
            }
        }
    }
}
