import QtQuick 2.7

import com.viavi.style 1.0


Column{

    id: firstColumn1

    property int maxComponentsWidth: Math.max(value1Id.width, value2Id.width)

    property alias value1Text: value1Id.text
    property alias value2Text: value2Id.text
    property alias value1Font: value1Id.font
    property alias value2Font: value2Id.font
    
    property color value1Color
    property color value2Color

    property bool isCaptionColumn
    property bool centerContent: false

    topPadding: ViaviStyle.layout.mediumMargin
    bottomPadding: ViaviStyle.layout.mediumMargin

    spacing: ViaviStyle.layout.smallMargin

    Text{
        id: value1Id

        anchors.horizontalCenter: centerContent ? parent.horizontalCenter : undefined
        anchors.left: isCaptionColumn ? parent.left : undefined
        anchors.right: centerContent ? undefined : isCaptionColumn ? undefined : parent.right

        height: ViaviStyle.layout.tableFontMetrics.height
        width: contentWidth
        
        color: value1Color
    }

    Text{
        id: value2Id

        anchors.horizontalCenter: centerContent ? parent.horizontalCenter : undefined
        anchors.left: isCaptionColumn ? parent.left : undefined
        anchors.right: centerContent ? undefined : isCaptionColumn ? undefined : parent.right

        height: ViaviStyle.layout.tableFontMetrics.height
        width: contentWidth
        
        color: value2Color
    }
}
