import QtQuick 2.3
import libpow 1.0

import "Pow_Lib.js" as Pow_Lib

import com.viavi.style 1.0
import com.viavi.fiberutilui.Util_Ui_Qt 1.0

Rectangle {
	id: pow_elem

	property int pow_number : 1
	property PowDigit pow_digit : (pow_number == 1) ? pow_digit1 : pow_digit2
    property bool mode_1330_1550  : (pow_digit1.Wavelength === "1310" && pow_digit2.Wavelength ==="1550")
	color: "white"
	border.width: 2
    border.color: ViaviStyle.colors.lightGray2

	Row {
		Rectangle {
			id: info_wave
			width: pow_elem.width / 3
			height: pow_elem.height

			color: "white"
			border.width: 2

            border.color: ViaviStyle.colors.lightGray2

			Column {
				Row {
                    spacing: 5

					Rectangle {
						width: 10
						height: 10
					}
					Image {
                        id: channel_icon
						width: 48
						height: 48
						source: Pow_Lib.pow_get_icon( pow_digit )
						fillMode: Image.PreserveAspectFit
                        opacity: !mode_1330_1550  ?  1:0
					}

					Text {
                        anchors.bottom: channel_icon.bottom
						width: info_wave.width - x
						height: info_wave.height / 3
						text: Pow_Lib.pow_get_name( pow_digit )
                        fontSizeMode : Text.Fit
                        color: ViaviStyle.colors.viaviPurple
						verticalAlignment: Text.AlignVCenter

						font.family: "DejaVuLGCSansCondensed"
						font.bold: false
						font.pixelSize: 25
                        visible: !mode_1330_1550
					}
				}

				Text {
					width: info_wave.width
					height: (info_wave.height / 3) * 2
					text: Pow_Lib.pow_get_wavelength( pow_digit )
                    fontSizeMode : Text.Fit
                    color: ViaviStyle.colors.viaviPurple
					horizontalAlignment: Text.AlignHCenter
					verticalAlignment: Text.AlignTop

					font.family: "DejaVuLGCSansCondensed"
					font.bold: true
					font.pixelSize: 40
				}
			}

			MouseArea {
				anchors.fill: parent
				onClicked: {
					pow_digit.Pow_Digit_Next_Wavelength()
				}
			}
		}

		Rectangle {
			id: textPow
			width: (pow_elem.width / 3) * 2
			height: pow_elem.height

			color: "white"
			border.width: 2
            border.color: ViaviStyle.colors.lightGray2

			Text {
				color: Pow_Lib.pow_get_alarm_color( pow_digit )

				anchors.fill: parent

				text: Pow_Lib.pow_get_power( pow_digit )
				horizontalAlignment: Text.AlignHCenter
				verticalAlignment: Text.AlignVCenter
                fontSizeMode : Text.Fit
				font.family: "DejaVuLGCSansCondensed"
				font.bold: true
				font.pixelSize: 70

				transitions: Transition {
					to: "*"
					PropertyAnimation {id: textPow2toTomato; target: textPow; properties: "color"; duration: 1000}
					PropertyAnimation {id: textPow2toBlue; target: textPow; properties: "color"; duration: 1000}
				}
			}

			BarGraph {
				width: textPow.width - 40
				height: 30
				anchors.bottom : parent.bottom
				anchors.left : parent.left
				anchors.right : parent.right
				landscape: true
				haveTrigger: pow_digit.AlarmOn
				triggerLow: pow_digit.Trigger_Low
				triggerHigh: pow_digit.Trigger_High
				pourcentage: Pow_Lib.pow_get_pourcent(pow_digit)
			}
		}
	}
}
