import QtQuick 2.3
import "Viavi_Colors.js" as VColor
import libjobmgr 1.0

Rectangle {
    id: testReportsPanel
    width: jobInfoPanel.width
    color: VColor.cViaviColorDarkGray
    anchors.horizontalCenter: parent.horizontalCenter
    anchors.top: testReportsHeader.bottom
    anchors.topMargin: 3
    visible : isJobTestReportsPanelOn
    height: isJobTestReportsPanelOn ? testReportsList.height : 0 // depends on nbr of lines to display in List View (but could also be limlited to less than this?)
    
    Column {
       id: testReportsList
       width: testReportsPanel.width
           
       Repeater {
           model: Job_Mgr.testReportsModel
               
            Row {
                id: testReportsRow
                spacing: lineSpacing
                height: lineHeight
                
                visible: testReportVisible
                
                Rectangle {
                    id: testReportsName
                    color: VColor.cViaviColorLightGray2
                    width: 180
                    height: parent.height
                    
                    Text {
                        id: testReportsText
                        anchors.verticalCenter: parent.verticalCenter
                        anchors.fill: parent
                        anchors.left: parent.left
                        anchors.leftMargin: 20
                        verticalAlignment: Text.AlignVCenter
                        color: VColor.cViaviRealBlack
                        text: testReportTypeRole
                        font.bold: true
                        font.pointSize: 12
                        }
                    }

                Rectangle {
                    id: testReportsContent
                    color: VColor.cViaviColorWhite
                    width: testReportsPanel.width - testReportsName.width
                    height: parent.height
                    Text {
                         id: testReportDetail
                         anchors.top: parent.top
                         anchors.topMargin: 3
                         anchors.left: parent.left
                         anchors.leftMargin: 10
                         anchors.right: testPassFailIcon.left
                         anchors.rightMargin: 10
                         color: VColor.cViaviColorDarkGray
                         text: testReportFilePathRole
                         font.pointSize: 10
                         elide: Text.ElideLeft
   			             }

                    Text {
                         id: testReportDetail2
                         anchors.bottom: parent.bottom
                         anchors.bottomMargin: 3
                         anchors.left: testReportDetail.left
                         anchors.right: testPassFailIcon.left
                         anchors.rightMargin: 10
                         color: VColor.cViaviColorDarkGray
                         text: testReportRefInfoRole + " Comment: " + testReportCommentRole // TBD how should we show any comments
                         font.pointSize: 10
                         elide: Text.ElideRight
                         }
                        
                    Image {
                        id: testPassFailIcon
                        source: testReportIconRole
                        anchors.verticalCenter: parent.verticalCenter
                        anchors.right: parent.right
                        anchors.rightMargin: 10
                        }
                    
                    Rectangle { // Line Separator
                        color: VColor.cViaviColorLightGray3
                        anchors.horizontalCenter: parent.horizontalCenter
                        anchors.bottom: parent.bottom
                        width: parent.width
                        height: 1
                        }
                    }
                }
           } // end Repeater
        }
    }
