import QtQuick 2.3
import "Viavi_Colors.js" as VColor
import libjobmgr 1.0

Rectangle {
    id: container

    width: 600
    height: 250

    color: VColor.cViaviColorLightGray2 //"lightgrey"
    
    border.color: VColor.cViaviColorGray
    border.width: 4
    
    property int standardHeight: 40

    property int choiceComment: 0
    
    property string personnalComment: ""
    property string autoComment: ""
    property int currentCode: -1
    property int indexTestPlan: -1
    property int containerTextSize: 12
    
    property string inputHeadertext: ""
    property string inputAutoHeadertext: ""
    property string inputPersonnalHeaderText: ""

    property bool bDisplayList: false
    
    function close( validation ) {
      if ( validation != false )
         {
         Job_Mgr.Valid_Skip_Comments( container.indexTestPlan, container.autoComment , container.personnalComment );
         }
      container.visible = false;
      
      container.autoComment = "";
      container.personnalComment = "";
      container.indexTestPlan = -1;
      container.currentCode = -1;
      container.bDisplayList = false;
    }
    
    Text {
      id: textHeader
      
      anchors.left: container.left
      anchors.leftMargin: 10
      anchors.top: container.top
      anchors.topMargin: 10
      
      text: container.inputHeadertext
      
      font.bold: true
      font.pointSize: 16
      font.family: "DejaVu LGC Sans"
    }
    
    Text {
      id: textHeaderAutoComment
      
      anchors.left: autoCommentContainer.left
      anchors.top: textHeader.bottom
      anchors.topMargin: 10
      
      text: container.inputAutoHeadertext
      
      font.italic: true
      font.pointSize: 12
      font.family: "DejaVu LGC Sans"
    }
    
    Text {
      id: textHeaderPersonnalComment
      
      anchors.left: personnalCommentContainer.left
      anchors.top: textHeader.bottom
      anchors.topMargin: 10
      
      text: container.inputPersonnalHeaderText
      
      font.italic: true
      font.pointSize: 12
      font.family: "DejaVu LGC Sans"
    }
    
    Rectangle {
      id: autoCommentContainer
      
      height: standardHeight
      width: container.width * 0.4
      anchors.left: container.left
      anchors.leftMargin: 20
      anchors.top: textHeaderAutoComment.bottom
      anchors.topMargin: 5
      
      clip: true
      
      Text {
          anchors.verticalCenter: parent.verticalCenter
          anchors.left: parent.left
          anchors.leftMargin: 3
          font.pointSize: containerTextSize
          text: container.autoComment
          font.family: "DejaVu LGC Sans"
      }
    }
    
    Rectangle {
      id: displayListButton
      width: height
      height: standardHeight
      anchors.left: autoCommentContainer.right
      anchors.verticalCenter: autoCommentContainer.verticalCenter
      color: VColor.cViaviColorGray
      
      clip: true
      
      Image {
         anchors.centerIn: parent
         source: container.bDisplayList ? "/acterna/storage/look-and-feel/generic/Open_32.png" : "/acterna/storage/look-and-feel/generic/Close_32.png"
         
         fillMode: Image.PreserveAspectFit
      }

      MouseArea {
          anchors.fill: parent

          onClicked: {
              container.bDisplayList = !container.bDisplayList;
          }
      }
    }
    
    Rectangle {
      id: personnalCommentContainer
      
      anchors.left: displayListButton.right
      anchors.leftMargin: 10
      anchors.verticalCenter: autoCommentContainer.verticalCenter
      
      height: container.standardHeight
      width: container.width * 0.4
      
      clip: true
      
      function editText(txtOutput, validation) {   
         if (validation === true)
            {
            container.personnalComment = txtOutput;
            }
            
            keyboard.editText.disconnect( personnalCommentContainer.editText );   
            
            container.visible = true;
      }
      
      Text {
          id: personnalCommentText
          
          anchors.left: parent.left
          anchors.leftMargin: 3
          anchors.verticalCenter: parent.verticalCenter
          
          text: container.personnalComment
          font.family: "DejaVu LGC Sans"
          font.pointSize: containerTextSize
      }
      
      MouseArea {
         anchors.fill: parent
         
         onClicked: {
            container.visible = false;
         
            keyboard.editText.connect( personnalCommentContainer.editText );
            openKeyBoard( textHeader.text, personnalCommentText.text);
         }
      }
    }
    
    Rectangle {
      id: containerListView
      
      anchors.left: autoCommentContainer.left
      anchors.right: autoCommentContainer.right
      anchors.top: autoCommentContainer.bottom
      anchors.topMargin: 2
      anchors.bottom: buttonSelection.top
      anchors.bottomMargin: 2
      
      color: "white"
      
      visible: container.bDisplayList
      
      ListView {
          id: listAutoComment
      
          anchors.fill: parent
          anchors.margins: 2
          boundsBehavior: Flickable.StopAtBounds
          spacing: 2
          clip: true
      
          model: Job_Mgr.skipTestModel
      
          delegate: Rectangle {
                  width: parent.width
                  height: 20
                  color: index == container.currentCode ? VColor.cViaviColorLogoPurple : "transparent"
      
                  Text {
                      anchors.fill: parent
                      anchors.leftMargin: 5
                      verticalAlignment: Text.AlignVCenter
                      text: modelData
                      font.family: "DejaVu LGC SansCondensed"
                      font.pointSize: containerTextSize
                      color: index == container.currentCode ? VColor.cViaviColorWhite : VColor.cViaviRealBlack
                  }
      
                  MouseArea {
                      anchors.fill: parent
      
                      onClicked: {
                          container.currentCode = index;
                          container.autoComment = modelData;
                          container.bDisplayList = false;
                      }
                  }
              }
         }
    }
    
    Rectangle {
       id: buttonSelection
       
       height: 50 //container.standardHeight * 1.5
       
       property int buttonWidth: buttonSelection.height * 1.5
       property int buttonHeight: buttonSelection.height
       property int buttonMargin: 10

       color: VColor.cViaviColorLightGray2
       
       anchors.bottom: container.bottom
       anchors.left: container.left
       anchors.right: container.right
       
       Rectangle {
         anchors.top: parent.top
         anchors.bottom: parent.bottom
         anchors.left: parent.left
         anchors.right: rowButtons.left
         anchors.rightMargin: 2

         color: VColor.cViaviColorGray
       
         Text {
            id: pathText
            
            anchors.fill: parent
            color: VColor.cViaviColorWhite
            
            anchors.left: parent.left
            anchors.leftMargin: 10
            anchors.verticalCenter: parent.verticalCenter
            
            text: container.autoComment + " : " + container.personnalComment
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignLeft
            font.pointSize: 16
            //font.italic: true
            wrapMode: Text.NoWrap
            
            clip: true
         }
       }

       Row {
         id: rowButtons
         spacing: 2
         
         anchors.top: parent.top
         anchors.bottom: parent.bottom
         anchors.right: parent.right
         
         layoutDirection: Qt.RightToLeft
   
         Rectangle {
               id:validbutton
         
               color: VColor.cViaviColorGray
               width: buttonSelection.buttonWidth
               height: buttonSelection.buttonHeight
               clip: true
         
               Image {
                   id: imgValidButton
                   fillMode: Image.PreserveAspectFit
                   
                   anchors.fill: parent
                   anchors.margins: 4
                   smooth: true
         
                   source: "/acterna/storage/look-and-feel/generic/Wizard_Icon_Ok.png"
               }
         
         
               MouseArea {
                   id: mouseAreaValidButton
                   anchors.fill: parent
                   
                   onClicked: {
                     container.close( true );
                   }
               }
         
               states: State {
                   name: "pressed"
                   when: mouseAreaValidButton.pressed
                   PropertyChanges {
                       target: validbutton
                       color: VColor.cViaviColorLightBlue
                   }
//                   PropertyChanges {
//                       target: textValidButton
//                       font.bold: true
//                   }
               }
         }
   
         Rectangle {
               id:cancelbutton
   
               color: VColor.cViaviColorGray
   
               width: buttonSelection.buttonWidth
               height: buttonSelection.buttonHeight
               clip: true
   
               Image {
                   id: imgCancelButton
                   
                   fillMode: Image.PreserveAspectFit
                   anchors.fill: parent
                   anchors.margins: 4
                   smooth: true
         
                   source: "/acterna/storage/look-and-feel/generic/Wizard_Icon_Clear.png"
               }
   
               MouseArea {
                   id: mouseAreaCancelButton
                   anchors.fill: parent
                   
                   onClicked: {
                     container.close( false );
                   }
               }
   
               states: State {
                   name: "pressed"
                   when: mouseAreaCancelButton.pressed
                   PropertyChanges {
                       target: cancelbutton
                       color: VColor.cViaviColorLightBlue
                   }
//                   PropertyChanges {
//                       target: textCancelButton
//                       font.bold: true
//                   }
               }
         }
       }
    }
}

