import QtQuick 2.3
import QtQuick.Layouts 1.2


import com.viavi.style 1.0
import com.viavi.style.components 1.0


BasicContainer {
    id: container

    property Component selectedOverlay: null
    property int gridWidth: mainArea.width
    property alias mainAreaWidth: mainArea.width
    property alias titleFont: gridTitle.titleFont
    property alias titleAreaHeight: gridTitle.height
    property alias titleBackgroundColor: gridTitle.color

    clip: true

    property int titleCellHeight: ViaviStyle.layout.genericTableLineHeight
    property int headerCellHeight: ViaviStyle.layout.genericTableLineHeight
    property int dataCellHeight: ViaviStyle.layout.genericTableLineHeight

    property int headerTabHeight: ViaviStyle.layout.genericTableHeaderHeight

    property alias emptyCellText: gridData.emptyCellText
    
    property bool isInfo_Button_Available: false

	Rectangle {
        id: mainArea
		anchors.fill: parent
		anchors.margins: 2
		
		GenericTableGridTitle {
	    	id: gridTitle
	    	
            height: generictable_res_genericTableNbLineUpperTable.value * titleCellHeight
            cellHeight: titleCellHeight
            gridWidth: container.gridWidth
	    	
	    	anchors.top: parent.top
	    	anchors.left : parent.left
	        anchors.right : parent.right
	    }
		
		GenericTableGridHeader {
	    	id: gridHeader
	    	
            height: generictable_res_genericTableNbLineHeader.value * headerTabHeight
            cellHeight: headerCellHeight
            gridWidth: container.gridWidth
	    	
	    	anchors.top: gridTitle.bottom
	    	anchors.left : parent.left
	        anchors.right : parent.right
	        
	        headerHeight: headerTabHeight
	    }
		
	    GenericTableGridData {
	    	id: gridData
	    	
            selectedOverlay: container.selectedOverlay

            cellHeight: dataCellHeight
            gridWidth: container.gridWidth

	    	anchors.top: gridHeader.bottom
	    	anchors.bottom: parent.bottom
	    	anchors.left : parent.left
	        anchors.right : parent.right
	        
	        isDisplay_Info_Button_Available: isInfo_Button_Available
	        
	    }
    }
}

