import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0
import com.viavi.fiberutilui.components 1.0

Popup {
    id: rootPopup
    width: parent.width
    height: parent.height

    background: Rectangle {

        anchors.fill: parent

        color: ViaviStyle.colors.transparentBackgroundColor

        MouseArea{
            anchors.fill: parent

            onClicked: {

            }
        }
    }

    readonly property int borderSize: ViaviStyle.layout.mediumMargin
    readonly property int listElementHeight: ViaviStyle.layout.isSmallScreen ? ViaviStyle.layout.imageButtonHeight : ViaviStyle.layout.buttonHeight

    Rectangle {
        anchors.centerIn: parent
        anchors.margins: ViaviStyle.layout.veryLargeMargin
        color: ViaviStyle.colors.pageBackgroundColor

        width: ViaviStyle.layout.smallPopupWidth
        height: ViaviStyle.layout.isSmallScreen ? rootPopup.height : 660

        ColumnLayout {
            id: mainArea
            anchors.fill: parent

            Layout.fillHeight: true
            Layout.fillWidth: true

            Item {
                id: headerAndCloseButton
                Layout.fillWidth: true
                height: listElementHeight
                anchors.margins: borderSize

                Text {
                    id: headerText
                    font: ViaviStyle.layout.titleTextFont
                    text: synoptic_res_fixSendMessageLabel.value
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    anchors.centerIn: parent
                    color: ViaviStyle.colors.mainInfoColor
                }

                ImageButton {
                    id: button
                    anchors.right: parent.right
                    source: FiberStyle.images.closeButtonIcon
                    onClicked: {
                        // status_act_closeFixMessagePopup.invoke()
                        synoptic_act_sendFixMessageStr.invokeWithStringArg( "-1" )
                    }
                }

            }

            ListView {
                id: messageButtonsList
                Layout.fillWidth: true
                Layout.fillHeight: true
                spacing: borderSize

                property int selectedMsgType: -1
                property int selectedMsgParameter: -1

                boundsBehavior: Flickable.StopAtBounds
                snapMode: ListView.SnapToItem

                clip:true

                model: synoptic_res_fixMessagesList.value
                delegate: Button {
                    id: button
                    text: msgText
                    enabled: true
                    width: messageButtonsList.width - 2 * borderSize
                    height: listElementHeight
                    anchors.horizontalCenter: messageButtonsList.horizontalCenter
                    property int buttonMsgType: msgType
                    property string buttonMsgParameter: msgParameter

                    contentItem: Text {
                        font: ViaviStyle.layout.activeBoldTextFont
                        text: msgText
                        horizontalAlignment: Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
                        color: button.pressed ? ViaviStyle.colors.contentBackgroundColor : ViaviStyle.colors.activeColor
                    }

                    background: Rectangle {
                        color: button.pressed ? ViaviStyle.colors.activeColor : ViaviStyle.colors.contentBackgroundColor
                        anchors.fill: parent
                    }

                    onClicked: {
                        messageButtonsList.selectedMsgType = buttonMsgType
                        if (buttonMsgParameter.length > 0) {
                            synoptic_act_openFiberNbKeyboard.invokeWithStringArg(buttonMsgParameter)
                        }
                        else {
                            synoptic_act_sendFixMessageStr.invokeWithStringArg( messageButtonsList.selectedMsgType.toString())
                        }

                    }
                }
            }
        }
    }
}
