import QtQuick 2.3
import QtQuick.Controls 2.4
import "Viavi_Colors.js" as VColor
import libfexplor 1.0


Rectangle {
    id: globalRect
    property bool   bKeyPressed : false
    property string focuscolor  : "steelblue"
    property string colorfreeSpace : VColor.cViaviColorGray
    property string colorSlider    : VColor.cViaviColorGray
    property   int  cNoIdex : -1

    focus:  treeModel.dirFocus;

    function func_action_click( index ,isOpened, hasChildren ) {
        if (index > 0) {//icone Mts non clikable
            if ( treeModel.dirIndex !== index) {
                treeModel.dirIndex = index
            }

            if ( treeModel.dirFocus  === false) {
                treeModel.dirFocus = true ;
                qmlFileItemList.Focus = false ;
            }

            if ( hasChildren ){
                if (isOpened ){
                    treeModel.set_DirClose(index)
                }
                else{
                    treeModel.set_DirOpen(index)
                }
                treeView.positionViewAtIndex(treeModel.dirIndex,  ListView.Center)
            }
            else{
                treeModel.set_DirClose(index)
            }
        }
    }

    onFocusChanged: {
        if (focus) {
            id_animationslider_Vertical.restart()
        }
    }
    
    //Keys ----------------------------------------------------------------------------------------
    Keys.onPressed: {

        if (event.key === Qt.Key_Down){
            bKeyPressed = true

            if (  treeModel.dirIndex < treeView.count -1){
                treeModel.dirIndex =  treeModel.dirIndex + 1 ;
            }
        }
        else if (event.key === Qt.Key_Up){
            bKeyPressed = true
            if ( treeModel.dirIndex > 1){//icone Mts non clikable
                treeModel.dirIndex =  treeModel.dirIndex  - 1;
            }
        }
        else if (event.key === Qt.Key_Left){
            //console.log(" -t- Key_Left= ");
        }
        else if (event.key === Qt.Key_Return){
            if (treeModel.DirItemList[treeModel.dirIndex].hasChildren) {
                treeModel.DirItemList[treeModel.dirIndex].isOpened ? treeModel.set_DirClose( treeModel.dirIndex) : treeModel.set_DirOpen( treeModel.dirIndex);
                treeView.positionViewAtIndex(treeModel.dirIndex,  ListView.Center)
            }
            else{
                treeModel.set_DirClose( treeModel.dirIndex)
            }
        }
        else if (event.key === Qt.Key_Right){
            if ( treeModel.dirIndex === cNoIdex){//-1 no_index
                treeModel.dirIndex =  0;
            }

            // on passe du tree a la list view
            if ( treeModel.dirFocus  === true  && treeModel.DirItemList[treeModel.dirIndex].isHasFile === true){
                treeModel.dirFocus = false ;
                qmlFileItemList.Focus = true;
                if (qmlFileItemList.Index === cNoIdex){
                    qmlFileItemList.Index = 0;
                }
            }
        }
    }

    //Keys END----------------------------------------------------------------------------------------

    //Component----------------------------------------------------------------------------------------
    Component {
        id: treeDelegate

        Rectangle {
            id: rootItem
            height: treeModel.get_height_screen() >= 600 ? 25 : 35
            width: parent.width

            //Indentation dans tree
            Rectangle {
                id: levelMarginElement
                width:  (level >  1) ? ((level-1)* 20) : (0)
                anchors.left: rootItem.left
            }

            //Icone > ou v
            Rectangle {
                id:rect_id_txt_plus
                anchors.left:levelMarginElement.right
                anchors.verticalCenter: parent.verticalCenter
                width: (index >  0) ? 16 : 0
                height: 16
                border.width: 0
                anchors.leftMargin:  2
                color: "transparent"
                visible: hasChildren

                Triangle {
                    id:id_icone_triangle
                    width: parent.width
                    height: parent.height
                    anchors.centerIn: parent
                    color_rectangle: "white"
                    color_triangle:VColor.cViaviColorGray
                    angle: 45
                    visible: hasChildren
                    border_width : 0
                }

                MouseArea {
                    id :id_MouseArea_txt_plus
                    anchors.fill: parent
                    onClicked: {
                        //treeView.current_tree_txt_width = id_nameTextElement.paintedWidth
                        bKeyPressed = false
                        func_action_click(index,isOpened, hasChildren);
                    }
                }
            }

            //Image  directory
            Rectangle {
                id: nodeOpenElement
                anchors.left: rect_id_txt_plus.right
                anchors.leftMargin:  (index >  0) ? 5: 0
                anchors.verticalCenter: parent.verticalCenter

                height: 27 //treeView.rect_image_dirWidth//27 //icone dir height
                width:  27 //icone dir with

                Rectangle
                {
                    id:rect_image_dir
                    anchors.left:parent.left
                    width: parent.width
                    height: parent.height
                    anchors.centerIn: parent

                    Image {
                        id: id_icone_image
                        anchors.fill: parent
                        smooth: true
                        source:  "image://dirpng/" + treeModel.DirItemList[index].dir_Icone_Index;
                        MouseArea {
                            id:id_MouseArea_image_dir
                            anchors.fill: parent
                            onClicked: {

                                // treeView.current_tree_txt_width = id_nameTextElement.paintedWidth
                                bKeyPressed = false
                                func_action_click(index,isOpened, hasChildren);
                            }
                        }
                    }
                }
                states: [

                    //Open Dir
                    State {
                        name: "openedNode"
                        when: (hasChildren)&&(isOpened)

                        PropertyChanges {
                            target: id_icone_image
                            source: "image://dirpng/" + treeModel.DirItemList[index].dir_Icone_Index;
                        }

                        PropertyChanges {
                            target: id_icone_triangle
                            angle: 130
                            anchors.centerIn: parent
                            color_triangle:VColor.cViaviColorGray
                            visible:  (index >  0) ? (true) : (false)
                        }

                        PropertyChanges {
                            target: rect_dirname
                            color: treeModel.dirIndex == index ?  focuscolor : "transparent"
                        }
                    },

                    //Close Dir
                    State {
                        name: "closedNode"
                        when: (hasChildren)&&(!isOpened)

                        PropertyChanges {
                            target: id_icone_image
                            source: "image://dirpng/" +  treeModel.DirItemList[index].dir_Icone_Index;
                        }

                        PropertyChanges {
                            target: id_icone_triangle
                            angle: 90
                            color_triangle:VColor.cViaviColorGray
                            anchors.centerIn: parent
                            visible:  (index >  0) ? (true) : (false)
                        }
                    }
                ]
            }

            // Txt file name Dir
            Rectangle {
                id:rect_dirname_full
                height: parent.height
                anchors.right: rootItem.right
                anchors.verticalCenter: rootItem.verticalCenter
                anchors.left: nodeOpenElement.right
                anchors.leftMargin: 5
                objectName:  "obj_rect_dirname_full"

                Rectangle {
                    id:rect_dirname
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.left: parent.left
                    width : parent.width
                    height: id_nameTextElement.height + 7
                    color: (treeModel.dirIndex == index ) ?  focuscolor:"transparent"
                    objectName:  "obj_rect_dirname"
                    opacity: (treeModel.dirIndex == index ) ?( (treeModel.dirFocus === true) ? 1 : 0.5): 1
                    smooth: true
                    radius: 1

                    Text {
                        id: id_nameTextElement
                        smooth: true
                        text:dirName
                        anchors.verticalCenter: parent.verticalCenter
                        anchors.horizontalCenter:  parent.horizontalCenter
                        anchors.left: parent.left
                        font.family: "DejaVuLGCSansCondensed"
                        color:  (treeModel.dirIndex == index ) ?  "white":"black"
                        font.pixelSize: treeModel.get_height_screen() >= 600 ? 16 : 20
                        objectName:  "obj_nameTextElement"
                        onPaintedWidthChanged: {
                            if ( id_nameTextElement.paintedWidth > treeView.max_tree_txt_width){
                                treeView.max_tree_txt_width = id_nameTextElement.paintedWidth
                            }

                        }
                    }
                }

                MouseArea {
                    id : id_MouseAreadirname
                    anchors.fill: parent
                    onClicked: {
                        bKeyPressed = false

                        if  (treeModel.dirIndex === index) {
                            func_action_click(index, isOpened, hasChildren);
                        }
                        else if ( index > 0 ) {
                            treeModel.dirIndex = index
                        }
                    }
                }
            }
        }
    }
    //END Component----------------------------------------------------------------------------------------

    //Tree List----------------------------------------------------------------------------------------
    Rectangle {
        id :rectList
        anchors.top  :  globalRect.top
        anchors.bottom: id_rec_free_space.top
        width: parent.width ;
        clip: true
        Rectangle {
            id:rectcontent
            width: parent.width ;
            color: "transparent"
            clip: true
            anchors.top:parent.top
            anchors.bottom: parent.bottom
            anchors.right:  parent.right

            onWidthChanged: {
                if (treeView.width  < rectcontent.width){
                    treeView.width =  rectcontent.width
                }
            }

            Flickable {
                id:id_flickable
                anchors.fill: parent
                flickableDirection: Flickable.HorizontalFlick
                boundsBehavior: Flickable.StopAtBounds
                contentWidth:   treeView.width
                maximumFlickVelocity: 1800

                ListView {
                    id: treeView
                    property  real   max_tree_txt_width: 0
                    property  real   current_tree_txt_width  :   0
                    property  real  levelMarginElementWidth  :  (treeModel.DirItemList[treeModel.dirIndex] !== undefined  && treeModel.DirItemList[treeModel.dirIndex].level >  1) ? ((treeModel.DirItemList[treeModel.dirIndex].level-1)* 20) : (0)
                    property  real  rect_id_txt_plusWidth    :  (treeModel.dirIndex >  0) ? 16 : 0
                    property  real  rect_image_dirWidth      :   27
                    property  real  sum_width : levelMarginElementWidth + rect_id_txt_plusWidth + rect_image_dirWidth

                    function qtest_findVisualChild(parent, objectName) {
                        if (!parent || parent.children === undefined)
                            return null;
                        var i = 0
                        var child
                        for ( i = 0; i < parent.children.length; ++i) {
                            child = parent.children[i];
                            if (child.objectName === objectName)
                                return child;
                        }

                        for (i = 0; i < parent.children.length; ++i) {
                            child = qtest_findVisualChild(parent.children[i], objectName);

                            if (child)
                                return child;
                        }
                        return null;
                    }

                    delegate: treeDelegate
                    model: treeModel.DirItemList
                    width:  rectcontent.width
                    height: rectcontent.height
                    clip:true
                    currentIndex: treeModel.dirIndex
                    flickableDirection: Flickable.VerticalFlick
                    boundsBehavior: Flickable.StopAtBounds
                    maximumFlickVelocity: 1800
                    ScrollBar.vertical:verticalBar
                    x:0
                    y:0

                    onCountChanged: {

                        if ( treeModel.dirIndex > 6) {
                            positionViewAtIndex(treeModel.dirIndex ,  ListView.Center);
                        }

                        //  console.log( "onCountChanged");
                    }

                    Connections{
                        target: treeModel
                        function onDirIndexChanged() {
                            //console.log( "onCurrentIndexChanged ");
                            if (bKeyPressed === true){
                                treeView.positionViewAtIndex(treeModel.dirIndex  ,  ListView.Center);
                            }

                            //decalage à chaque fois q'on descent dans l arborescence apres 3 sous repertoire.
                            id_flickable.contentX =  ((treeModel.DirItemList[treeModel.dirIndex ] && treeModel.DirItemList[treeModel.dirIndex ].level >  3) ? ((treeModel.DirItemList[treeModel.dirIndex].level-1)* 20) : (0))
                            id_animationslider_Vertical.restart()

                            //var varobj_name
                            //varobj_name = qtest_findVisualChild( treeView.currentItem , "obj_nameTextElement");


                            //                        // Set the property
                            //                        varobj_name.text = "Hey Yo!";
                            //                        // Ge the property
                            //                        console.log(varobj_name.text);

                            treeView.current_tree_txt_width = treeView.max_tree_txt_width //varobj_name.paintedWidth

                            treeView.sum_width =  treeView.current_tree_txt_width
                                    + treeView.levelMarginElementWidth
                                    + treeView.rect_id_txt_plusWidth
                                    + treeView.rect_image_dirWidth
                                    + 40
                                    + id_flickable.contentX

                            if ( treeView.sum_width < rectcontent.width ) {
                                treeView.width = rectcontent.width + id_flickable.contentX
                            }
                            else {
                                treeView.width =  treeView.sum_width
                            }
                        }

                    }

                    onMovingVerticallyChanged:{
                        if (treeView.movingVertically == true) {
                            id_animationslider_Vertical.stop()
                            verticalBar.opacity = 1
                        }
                        else if (treeView.movingVertically == false){
                            id_animationslider_Vertical.restart()
                        }
                    }

                    Component.onCompleted: {
                        if ( treeModel.dirIndex > 6) {
                            positionViewAtIndex(treeModel.dirIndex  - 4  ,  ListView.Center);
                        }

                        id_animationslider_Vertical.start();
                    }
                }
            }
        }

        PropertyAnimation {
            id: id_animationslider_Vertical
            target: verticalBar
            property: "opacity"
            from: 1
            to: 0
            duration: 3000
            easing.type:Easing.InExpo
        }

        ScrollBar {
            id: verticalBar
            anchors.right: parent.right
            anchors.rightMargin: 1
            anchors.top: parent.top
            anchors.topMargin: 5
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 5
            hoverEnabled: true
            orientation: Qt.Vertical
            minimumSize : 0.25
            policy: treeView.contentHeight >  treeView.height * 1.05 ? ScrollBar.AsNeeded : ScrollBar.AlwaysOff

            onHoveredChanged: {
                id_animationslider_Vertical.restart()
            }

            onPressedChanged: {
                if (verticalBar.pressed ) {
                    id_animationslider_Vertical.stop()
                    verticalBar.opacity = 1
                }
                else {
                    id_animationslider_Vertical.restart()
                }
            }

            contentItem: Rectangle {
                implicitWidth: 9
                implicitHeight: 100
                radius: width / 2
                color:verticalBar.pressed ?  focuscolor : colorSlider
            }
        }
    }


    //rectangle indiquant espage disponible
    Rectangle {
        id : id_rec_free_space
        anchors.bottom: globalRect.bottom
        anchors.left  : globalRect.left
        anchors.right: globalRect.right
        width: globalRect.width;
        height: 30
        color: colorfreeSpace
        radius:2

        Text {
            id: txt_free_size
            font.family: "DejaVuLGCSansCondensed"
            font.pixelSize: 15;
            color: "white"
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            anchors.verticalCenter: parent.verticalCenter
            anchors.horizontalCenter: parent.horizontalCenter
            text: treeModel.txtFreeSpace
        }
    }
}


