import QtQuick 2.3
import QtQuick.Layouts 1.1

import com.viavi.style 1.0


Rectangle{
    id: fcompRoot

    readonly property real scaleFactorFCompTabRow: ViaviStyle.layout.isSmallScreen ? 0.70 : 1
    readonly property real scaleFactorFCompTableCellHeight: 1.5

    property real maxTableDataCellHeight: ( genericTableFComp.height - genericTableFComp.titleCellHeight
                                           - genericTableFComp.headerCellHeight ) / generictable_res_genericTableNbLineData.value

    property int fixTableTitleHeight: ViaviStyle.layout.imageButtonHeight + 2 * ViaviStyle.layout.smallMargin
    property int fixTableDefaultVisibleLines: 3
    property int fixTableHeaderVisibleLines: 2
    property int fixTableDefaultHeight: (fixTableHeaderVisibleLines + fixTableDefaultVisibleLines) * ViaviStyle.layout.genericTableLineHeight
                                        + fixTableTitleHeight + ViaviStyle.layout.smallMargin //title + header + actual lines + bottom margin

    property bool isProcessView: fcomp_res_view.value === fcomp_res_view.enums.efvProc
    property bool isIlOrlSummaryView: fcomp_res_view.value === fcomp_res_view.enums.efvIlOrl
    property bool isLoopbackMode: fcomp_res_isLoopbackModeEnabled.value

    anchors.fill: parent

    color: ViaviStyle.colors.pageBackgroundColor
    
    function updateCustomDialogValue( customDialogY ) {
        dialog_cfg_customX.value = mainColumn.x 
        dialog_cfg_customY.value = mainColumn.y + customDialogY
        dialog_cfg_customWidth.value = mainColumn.width
        dialog_cfg_customHeight.value = fixTableDefaultHeight
    }

    ColumnLayout {
        id: mainColumn

        anchors.left: parent.left
        anchors.right: parent.right
        anchors.leftMargin : ViaviStyle.layout.largeMargin
        anchors.rightMargin : ViaviStyle.layout.largeMargin

        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.topMargin : ViaviStyle.layout.mediumMargin
        anchors.bottomMargin : ViaviStyle.layout.mediumMargin

        spacing: ViaviStyle.layout.mediumMargin

        Item {
            height: ViaviStyle.layout.buttonHeight * fcompRoot.scaleFactorFCompTabRow - mainColumn.spacing
            Layout.fillWidth: true

            FCompTabRow {
                anchors.topMargin: - mainColumn.anchors.topMargin
                anchors.bottomMargin: - mainColumn.spacing
                anchors.fill: parent
            }
        }

        SummaryInfo {
            id: summaryFComp

            visible: !status_res_schematicEnabled.value
            Layout.fillWidth: true
            Layout.preferredHeight: summaryFComp.height
        }

        MiniSlm {
            id: miniSlmFcomp

            visible: status_res_schematicEnabled.value
            Layout.fillWidth: true
            Layout.preferredHeight: summaryFComp.height

            selectedItemIndex: schematic_cfg_slmCurrentEvent.value

            firstLastFromTrace: false
            firstItemDistance: schematicFcomp.firstItemDistance
            lastItemDistance:  schematicFcomp.lastItemDistance
        }

        FixSynoptic {
            id: synopticFComp
            
            visible: isProcessView && !status_res_schematicEnabled.value
            Layout.fillWidth: true
            Layout.fillHeight: true
        }

        Loader {
            source: 'FixSynoptic_TestModule.qml'
            id: testModule
            
            visible: synoptic_res_testModuleEnabled.value && synopticFComp.testModuleVisible

            active: synoptic_res_testModuleEnabled.value && synopticFComp.testModuleVisible
            Layout.fillWidth: true
            Layout.preferredHeight: fixTableDefaultHeight
        }

        GenericTable {
            id: genericTableFComp

            visible: !( isProcessView && !fcomp_res_isReferenceTableSelected.value )
                     && !status_res_schematicEnabled.value && !testModule.visible
                     
            onVisibleChanged: {
            	if ( visible ) {
            	   updateCustomDialogValue( genericTableFComp.y )
            	} 
            }
            
            onYChanged: {
               if ( visible ) {
            	   updateCustomDialogValue( genericTableFComp.y )
               } 
            }
            
            Layout.fillWidth: true
            Layout.preferredHeight: fixTableDefaultHeight
            Layout.fillHeight: synopticFComp.visible ? false: true

            titleCellHeight: ( fcomp_res_isCableTableSelected.value || fcomp_res_isReferenceTableSelected.value )
                             ? fixTableTitleHeight
                             : ViaviStyle.layout.genericTableLineHeight
            titleFont: ( fcomp_res_isCableTableSelected.value || fcomp_res_isReferenceTableSelected.value )
                        ? ViaviStyle.layout.veryLargeFont
                         : ViaviStyle.layout.tableTitleFont

            emptyCellText: isIlOrlSummaryView ? "": "--"
            
            headerTabHeight: fcomp_res_isReferenceTableSelected.value ? ViaviStyle.layout.genericTableLineHeight : ViaviStyle.layout.genericTableHeaderHeight

            headerCellHeight: isIlOrlSummaryView ? ViaviStyle.layout.genericTableLineHeight * fcompRoot.scaleFactorFCompTableCellHeight
                                                 : ViaviStyle.layout.genericTableLineHeight
            dataCellHeight: isIlOrlSummaryView ? Math.min( ViaviStyle.layout.genericTableLineHeight * fcompRoot.scaleFactorFCompTableCellHeight
                                                , fcompRoot.maxTableDataCellHeight )
                                               : ViaviStyle.layout.genericTableLineHeight
                                               
            isInfo_Button_Available: isIlOrlSummaryView && !isLoopbackMode

            FCompCableTableLineOverlay{
                visible: fcomp_res_isCableTableSelected.value

                anchors.left: parent.left
                anchors.right : parent.right
                anchors.top: parent.top
                anchors.topMargin: ViaviStyle.layout.mediumMargin
            }

            FCompReferenceTableOverlay{
                visible: fcomp_res_isReferenceTableSelected.value

                anchors.left: parent.left
                anchors.right : parent.right
                anchors.top: parent.top
                anchors.topMargin: ViaviStyle.layout.mediumMargin
            }
        }

        Rectangle {
            id: emptyRect
            visible: isProcessView && !fcomp_res_isReferenceTableSelected.value
                     && !mappingMPO.visible && !testModule.visible
            Layout.fillWidth: true
            Layout.preferredHeight: fixTableDefaultHeight
            color: ViaviStyle.colors.pageBackgroundColor
            
            onVisibleChanged: {
            	if ( visible ) {
            	   updateCustomDialogValue( emptyRect.y )
            	} 
            }
            
            onYChanged: {
               if ( visible ) {
            	   updateCustomDialogValue( emptyRect.y )
               } 
            }
        }

        FCompMPOPolarity {
            id: mappingMPO
            visible: isProcessView && !fcomp_res_isReferenceTableSelected.value
                        && polarity_res_isSwitchReady.value
            Layout.fillWidth: true
            Layout.preferredHeight: fixTableDefaultHeight
            
            onVisibleChanged: {
            	if ( visible ) {
            	   updateCustomDialogValue( mappingMPO.y )
            	} 
            }
            
            onYChanged: {
               if ( visible ) {
            	   updateCustomDialogValue( mappingMPO.y )
               } 
            }
        }

        Schematic {
            id: schematicFcomp
            Layout.fillWidth: true

            height: ViaviStyle.layout.schematicHeight
            visible: status_res_schematicEnabled.value
            detailModeAlwaysOn: true
        }

        Item {
            Layout.fillWidth: true

            visible: status_res_eventDetailEnabled.value
            Layout.fillHeight: true

            Loader {
                id: eventFComp
                anchors.fill: parent

                source: ViaviStyle.layout.isSmallScreen ?
                            "EventInfoOptimeterLayout.qml" : "EventInfo.qml"
            }
        }
    }
}
