import QtQuick 2.3
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0


BasicContainer {
    id: rootItem

    property string event_problemEvent: ""
    property string event_diagnosisCause: ""
    property string event_threshold1: ""
    property string event_threshold2: ""

    width: parent.width
    height: parent.height

    ColumnLayout {
        id: detailTextColumn
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.margins: ViaviStyle.layout.veryLargeMargin

        Text {
            id: eventProblemText
            Layout.fillWidth: true
            horizontalAlignment:Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font: ViaviStyle.layout.largeFont
            color: ViaviStyle.colors.mainInfoColor
            wrapMode: Text.WordWrap
            text: event_problemEvent
            visible: text && text.length > 0
        }

        Text {
            id: eventThreshold1
            Layout.fillWidth: true
            horizontalAlignment:Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font: ViaviStyle.layout.mediumFont
            color: ViaviStyle.colors.secondaryInfoColor
            wrapMode: Text.WordWrap
            text: event_threshold1
            visible: text && text.length > 0
        }

        Text {
            id: eventThreshold2
            Layout.fillWidth: true
            horizontalAlignment:Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font: ViaviStyle.layout.mediumFont
            color: ViaviStyle.colors.secondaryInfoColor
            wrapMode: Text.WordWrap
            text: event_threshold2
            visible: text && text.length > 0
        }

        Text {
            id: diagnosisCause
            Layout.fillWidth: true
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font: ViaviStyle.layout.mediumFont
            color: ViaviStyle.colors.secondaryInfoColor
            wrapMode: Text.WordWrap
            text: event_diagnosisCause
            visible: text && text.length > 0
        }
    }
}
