import QtQuick 2.7
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0


Rectangle {
    id: root

    color: ViaviStyle.colors.pageBackgroundColor

    property double colorIntensity: dtsBattery_cfg_colorIntensity.value / 255.0
    property double maxTemp: dtsBattery_cfg_maxTemp.value
    property double minTemp: dtsBattery_cfg_minTemp.value

    function getColor(temperature){
        if(temperature < minTemp){
            return Qt.rgba(0,0, colorIntensity, 1.0)
        }
        if(temperature > maxTemp){
            return Qt.rgba(colorIntensity,0, 0, 1.0)
        }
        var sector = (maxTemp - minTemp) / 4
        var base = maxTemp - sector
        if(temperature >= base){

            return Qt.rgba(colorIntensity, (1.0 - (temperature - base) / sector) * colorIntensity, 0, 1.0)
        }
        base = maxTemp - 2 * sector
        if(temperature >= base){
            return Qt.rgba((temperature - base) / sector * colorIntensity, colorIntensity, 0, 1.0)
        }

        base = maxTemp - 3 * sector
        if(temperature >= base){
            return Qt.rgba(0, colorIntensity, (1.0 - (temperature - base) / sector) * colorIntensity, 1.0)
        }

        return Qt.rgba(0, (temperature - minTemp) / sector * colorIntensity, colorIntensity, 1.0)
    }

    BasicContainer{
        anchors.fill: parent

        anchors.leftMargin : ViaviStyle.layout.largeMargin
        anchors.rightMargin : ViaviStyle.layout.largeMargin

        anchors.topMargin : ViaviStyle.layout.mediumMargin
        anchors.bottomMargin : ViaviStyle.layout.mediumMargin

        Item {
            id: gridBackground
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.right: legend.left
            anchors.left: parent.left



            anchors.leftMargin : 2 * ViaviStyle.layout.mediumMargin
            anchors.rightMargin :2 *  ViaviStyle.layout.mediumMargin

            anchors.topMargin : 2 * ViaviStyle.layout.mediumMargin
            anchors.bottomMargin : 2 * ViaviStyle.layout.mediumMargin

            property int cellSize: Math.min(height / dtsBattery_cfg_nbOfRows.value
                                            , width / dtsBattery_cfg_nbOfColumns.value)

            property int cellRadius: cellSize / 2 - ViaviStyle.layout.smallMargin

            Canvas {
                anchors.fill: grid
                contextType: "2d"

                property int cellSize: parent.cellSize
                property int cellRadius: parent.cellRadius
                property int nrOfColumns: dtsBattery_cfg_nbOfColumns.value
                property int nrOfRows: dtsBattery_cfg_nbOfRows.value

                onPaint: {
                    getContext("2d")
                    if(context){
                        context.clearRect(0, 0, width, height)
                        context.lineWidth = 1
                        context.strokeStyle = Qt.rgba(0,0,1);
                        context.beginPath();
                        for ( var i = 0; i < nrOfColumns * nrOfRows; i++) {
                            var column = i % nrOfColumns
                            var row = Math.floor(i / nrOfColumns)
                            var nextColumn = column + 1
                            var lastOnRow = false
                            var reverseRow = false

                            if(row % 2 === 1){
                                lastOnRow = (column === (nrOfColumns - 1))
                            } else {
                                column = nrOfColumns - column - 1
                                nextColumn = column - 1
                                lastOnRow = (column === 0)
                                reverseRow = true
                            }

                            var startX = 0
                            var startY = 0

                            var endX = 0
                            var endY = 0

                            if(lastOnRow){
                                startX = column * cellSize + cellSize / 2
                                startY = row * cellSize + cellSize / 2 + cellRadius

                                endX = startX
                                endY = (row + 1) * cellSize + cellSize / 2 - cellRadius
                            } else {

                                    startX = column * cellSize + cellSize / 2
                                           + (reverseRow ? -1 : 1) * cellRadius * Math.cos(90 * 0.8)
                                    startY = row * cellSize + cellSize / 2
                                           - cellRadius * Math.sin(90 * 0.8)

                                    endX = nextColumn * cellSize + cellSize / 2
                                    endY = row * cellSize + cellSize / 2 - cellRadius
                            }

                            context.moveTo(startX, startY)
                            context.lineTo(endX, endY)

                        }
                        context.closePath()
                        context.stroke()
                    }
                }



                onContextChanged: requestPaint()

                onCellRadiusChanged: requestPaint()
                onCellSizeChanged: requestPaint()
                onNrOfColumnsChanged: requestPaint()
                onNrOfRowsChanged: requestPaint()

                onWidthChanged: requestPaint()
                onHeightChanged: requestPaint()

                Component.onCompleted: {
                    requestPaint()
                }
            }

            Grid {
                id: grid
                columns: dtsBattery_cfg_nbOfColumns.value
                rows: dtsBattery_cfg_nbOfRows.value

                width: columns * gridBackground.cellSize



                Repeater{
                    model: dtsBattery_res_temperatures.value


                    delegate: Item {
                        width: gridBackground.cellSize
                        height: gridBackground.cellSize

                        Rectangle {
                            anchors.centerIn: parent

                            radius: gridBackground.cellRadius
                            width: 2 * radius
                            height: 2 * radius

                            border.color: "blue"
                            border.width: 3

                            color: root.getColor(model.temperature)
                        }
                    }
                }
            }

            Rectangle{
                anchors.fill: grid

                anchors.leftMargin: - ViaviStyle.layout.mediumMargin
                anchors.rightMargin: - ViaviStyle.layout.mediumMargin

                anchors.topMargin: - ViaviStyle.layout.mediumMargin
                anchors.bottomMargin: - ViaviStyle.layout.mediumMargin

                border.color: "blue"
                border.width: 3

                radius: 20

                color: "transparent"
            }
        }

        HeatMapLegend{
            id: legend

            anchors.rightMargin :2 *  ViaviStyle.layout.mediumMargin

            anchors.topMargin : 2 * ViaviStyle.layout.mediumMargin
            anchors.bottomMargin : 2 * ViaviStyle.layout.mediumMargin

            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.right: parent.right

            colorIntensity: root.colorIntensity

            minValue: minTemp
            maxValue: maxTemp
        }
    }
}
