import QtQuick 2.3
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0

Item
{
    id: lockArea

    property CursorDragFiber topCursor
    property CursorDragFiber bottomCursor

    property int mouseAreaWidth

    property alias pressed: mouseArea.pressed
    property bool locked: topCursor ? topCursor.connectedCursor : false

    signal sgnToggle()

    width: height
    anchors.top: parent.top
    anchors.topMargin: ViaviStyle.layout.smallMargin
    anchors.bottom: parent.bottom
    anchors.bottomMargin: ViaviStyle.layout.smallMargin

    MouseArea {
        id: mouseArea
        
        height: parent.height
        width: mouseAreaWidth - lockedConnectionImgId.width
        anchors.left: parent.left
        anchors.leftMargin: lockedConnectionImgId.width

        onReleased: {
            sgnToggle()
        }
    }
    
    Row {
        anchors.fill: parent

        Item {
            height: parent.height
            width: lockedConnectionImgId.width

            ColorImage {
                id: lockedConnectionImgId

                visible: lockArea.locked
                height: parent.height
                source: FiberStyle.images.cursorsLockedConnectionBtnImg
                color: lockArea.pressed ? ViaviStyle.colors.selectedColor : "transparent"
                fillMode: Image.PreserveAspectFit
            }

            Image{
                source: FiberStyle.images.cursorABoxImg
                height: parent.height
                fillMode: Image.PreserveAspectFit
            }

            ColorImage {
                visible: topCursor
                         ? (!lockArea.locked
                            && topCursor.parentTrace.lastUsedCursor === topCursor)
                           || (lockArea.locked
                               && (topCursor.parentTrace.lastUsedCursor === topCursor
                                   || topCursor.parentTrace.lastUsedCursor === topCursor.connectedCursor))

                         : false
                height: parent.height
                source: FiberStyle.images.cursorASelectedImg
                color: lockArea.pressed ? ViaviStyle.colors.selectedColor : topCursor.color
                fillMode: Image.PreserveAspectFit
            }

            Image{
                source: FiberStyle.images.cursorBBoxImg
                height: parent.height
                fillMode: Image.PreserveAspectFit
            }

            ColorImage {
                visible: bottomCursor
                         ? (!lockArea.locked
                            && bottomCursor.parentTrace.lastUsedCursor === bottomCursor)
                           || (lockArea.locked
                               && (bottomCursor.parentTrace.lastUsedCursor === bottomCursor
                                   || bottomCursor.parentTrace.lastUsedCursor === bottomCursor.connectedCursor))

                         : false
                height: parent.height
                source: FiberStyle.images.cursorBSelectedImg
                color: lockArea.pressed ? ViaviStyle.colors.selectedColor : bottomCursor.color
                fillMode: Image.PreserveAspectFit
            }
        }
    }
}
