import QtQuick 2.3

import com.viavi.style 1.0

Rectangle {
	id: msgbox
	border.color: ViaviStyle.colors.viaviPurple
	border.width: 2
	property int label_goto: 1
	
	color: ViaviStyle.colors.lightGray2
    
    Column {
    
		Text {
			width: msgbox.width
			height: msgbox.height / 3
			
			color: "white"
			font.family: "Bitstream Vera Sans Roman"
			font.bold: true
			font.pixelSize: 24
			
		    horizontalAlignment: Text.AlignHCenter
		    verticalAlignment: Text.AlignVCenter
			
			text: "Switch to Label <i style=\"color:" + ViaviStyle.colors.viaviPurple + "\"\>" + label_goto + "</i>"
		}
		
		Row {
			Text {
				width: msgbox.width / 2
				height: msgbox.height / 3 
				
				color: "white"
				font.family: "Bitstream Vera Sans Roman"
				font.bold: true
				font.pixelSize: 24
				
			    horizontalAlignment: Text.AlignHCenter
			    verticalAlignment: Text.AlignVCenter
				
				text: "-"
				
				MouseArea {
					anchors.fill: parent
					
					onClicked: {
						if ( label_goto <= 10 ) {
							label_goto = 1;
						} else {
							label_goto = label_goto - 10;
						}
					}
				}
			}
			
			Text {
				width: msgbox.width / 2
				height: msgbox.height / 3
				
				color: "white"
				font.family: "Bitstream Vera Sans Roman"
				font.bold: true
				font.pixelSize: 24
				
			    horizontalAlignment: Text.AlignHCenter
			    verticalAlignment: Text.AlignVCenter
				
				text: "+"
				
				MouseArea {
					anchors.fill: parent
					
					onClicked: {
						if ( label_goto <= label_list.count - 1 ) {
							label_goto = label_goto + 10;
						} else {
							label_goto <= label_list.count;
						}
					}
				}
			}					 		 
		}
		
		Text {
			width: msgbox.width
			height: msgbox.height / 3
			
			color: "white"
			font.family: "Bitstream Vera Sans Roman"
			font.bold: true
			font.pixelSize: 24
			
		    horizontalAlignment: Text.AlignHCenter
		    verticalAlignment: Text.AlignVCenter
			
			text: "<i style=\"color:" + ViaviStyle.colors.viaviPurple + "\"\>Go To</i>"
			
			MouseArea {
				anchors.fill: parent
				
				onClicked: {
					msgbox.visible = false;
					cable_co_list.Label_Index = label_goto - 1;
					label_list.positionViewAtIndex(cable_co_list.Label_Index, ListView.Center)
					label_goto = 1;
				}
			}
		}
	}
}
