import QtQuick 2.3
import QtGraphicalEffects 1.0
import libfo 1.0

import com.viavi.style 1.0
import com.viavi.fiberutilui.components 1.0

Item {
    property bool selected: ( cable_co_list.Label_Index == index  && cable_co_list.Label_Selection_Mode != false )
    property bool open: ( index == cable_co_list.Label_Index_Open )
    
    property bool display: filterLabel.length > 0 ? label_text.text.toString().includes(filterLabel) : true
    
    property bool isExpandable: cable_co_list.MPO_Size > 1
    
    width: label_list.width
    // height: (open) ? 64 * 3 : 48
    height: display ? ( open ? 64 * 3 : 48 ) : 0
    
    function cable_get_label_icon( status, simplex )
	{
      var icon = "";
	  
	  if ( status == Label.CLabel_Status_Failed )
	  {
	    icon = "/acterna/storage/look-and-feel/generic/Cross_32.png";
	  }
	  else if ( status == Label.CLabel_Status_Ok )
	  {
	    icon = "/acterna/storage/look-and-feel/generic/Check_32.png";
	  }
	  else if ( status == Label.CLabel_Status_In_Progress )
	  {
	  	// Simplex -> in progress = done without alarm.
	  	if ( simplex )
	  		{
	  		// icon = "/acterna/storage/look-and-feel/generic/Check_32.png";
	  		}
	  	else
	  		{
	    	icon = "/acterna/storage/look-and-feel/generic/Progress_32_Enterprise.png";
	    	}
	  }
	  
	  return icon;
	}
	
	function cable_get_label_color( status )
	{
		var cable_back_col = ViaviStyle.colors.lightGray2;
		
		if ( status == Label.CLabel_Status_Not_To_test )
			{
			cable_back_col = ViaviStyle.colors.secondaryInfoColor;
			}
		else if ( status == Label.CLabel_Status_Ok )
			{
			cable_back_col = ViaviStyle.colors.green;
			}
		else if ( status == Label.CLabel_Status_Failed )
			{
			cable_back_col = ViaviStyle.colors.red;
			}
		
		return cable_back_col;
	}
	
	function cable_get_text_color( status )
	{
		var cable_back_col = ViaviStyle.colors.white;
		
		if ( status == Label.CLabel_Status_Ok )
			{
			cable_back_col = ViaviStyle.colors.green;
			}
		else if ( status == Label.CLabel_Status_Failed )
			{
			cable_back_col = ViaviStyle.colors.red;
			}
		
		return cable_back_col;
	}
	
	CableToggleFiberPopup { id: enablePopupId }

    Rectangle {
        id: line
        anchors.fill: parent

        color: selected ? ViaviStyle.colors.viaviPurple : cable_get_label_color( Label_Status )
        border.color: ViaviStyle.colors.darkGray
        border.width: 2
        
        clip: true

        Item {
            id: label_holder
            height: 32
            anchors.left: expander_image.right
            anchors.right: (label_status_image.source.toString().length > 0) ? label_status_image.left : parent.right
            anchors.leftMargin: 3
            anchors.rightMargin: 3
            anchors.topMargin: 8
            anchors.top : parent.top

            clip: true

            Text {
                id: label_text
                width: parent.width
                height: parent.height
                text: Label_Name
                color: selected ? cable_get_text_color( Label_Status ) : ViaviStyle.colors.viaviPurple
                font.pixelSize: 24
                font.family: "Bitstream Vera Sans Roman"
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
            }
        }

        Image {
            id: label_status_image
            height: 32
            width: 32
            anchors.right : parent.right
            anchors.top : parent.top
            source: cable_get_label_icon( Label_Status, !isExpandable ) // if isExpandable = FALSE -> Simplex
            anchors.rightMargin: 10
            anchors.topMargin: 8
        }
        
        ColorOverlay {
	        anchors.fill: label_status_image
	        source: label_status_image
	        color: "white"
	        visible: ( selected && label_status_image.status == Image.Ready ) ? true : false
    	}
        
        Image {
            id: expander_image
            height: 32
            width: 32
            anchors.left : parent.left
            visible: isExpandable
            anchors.top : parent.top
            source: open ? "/acterna/storage/look-and-feel/generic/Open_32.png" : "/acterna/storage/look-and-feel/generic/Close_32.png"
            anchors.leftMargin: 5
            anchors.topMargin: 8
        }
        
        ColorOverlay {
	        anchors.fill: expander_image
	        source: expander_image
	        color: "white"
	        visible: ( selected && expander_image.visible ) ? true : false
    	}
        
        Rectangle {
        	id: mpo_channel
        	
			visible: cable_co_list.Cable_List[index].Fiber_Channel != 0 && !expander_image.visible
			
            color: ViaviStyle.colors.lightBlue
			
			height: parent.height / 2
			width: height
			
			radius: width / 2
			
			anchors.left : parent.left
			anchors.leftMargin: 5
			anchors.verticalCenter: parent.verticalCenter
			
			Text {
            	text: cable_co_list.Cable_List[index].Fiber_Channel
				color: ViaviStyle.colors.viaviPurple
                font.pixelSize: 12
                font.family: "Bitstream Vera Sans Roman"
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.verticalCenter: parent.verticalCenter
			}
		}
        
        PopupMouseArea {
            anchors.fill: parent
            longPressMenu: enablePopupId
            disableLongPress: isExpandable
            z: parent.z + 1
            
            drag.target: label_text
            drag.axis: Drag.XAxis
            drag.minimumX: drag.target.width > drag.target.contentWidth ? 0 : drag.target.width - drag.target.contentWidth
            drag.maximumX: 0

	        onClicked: {
            	if ( selected )
            	{
            		cable_co_list.Label_Index_Open = ( index != cable_co_list.Label_Index_Open ? index : -1 );
            	}
            	else
            	{
            		cable_co_list.Label_Index = index;
            	}
            	
           		cable_co_list.Label_Selection_Mode = true
            	cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(index);
	        }
	    }
    }
}
