import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui.components 1.0

Rectangle {
    id: bargraphContainer

    height: (ViaviStyle.layout.smallMargin + ViaviStyle.layout.titleTextFontMetrics.height
             + ViaviStyle.layout.mediumMargin + ViaviStyle.layout.genericTableLineHeight
             / 2) * 2 // the progress bar will be centered

    //color: ViaviStyle.colors.contentBackgroundColor
    border.color: ViaviStyle.colors.borderColor
    border.width: ViaviStyle.layout.borderSize

    states: [
        State {
            name: "messageState"
            when: bargraph_res_bargraphType.value > 0
                  && bargraph_res_bargraphType.value < 4
            PropertyChanges {
                target: centralProgressItem
                visible: false
            }

            PropertyChanges {
                target: testConnectorItem
                visible: false
            }

            PropertyChanges {
                target: acquisitionProgressBar
                visible: false
            }

            PropertyChanges {
                target: leftLabel
                visible: false
            }
            PropertyChanges {
                target: rightLabel
                visible: false
            }
        },
        State {
            name: "testConnectorState"
            when: bargraph_res_bargraphType.value === 4
            PropertyChanges {
                target: centralProgressItem
                visible: true
            }
            PropertyChanges {
                target: testConnectorItem
                visible: true
            }
            PropertyChanges {
                target: acquisitionProgressBar
                visible: false
            }
            PropertyChanges {
                target: leftLabel
                visible: true
            }
            PropertyChanges {
                target: rightLabel
                visible: true
            }
            PropertyChanges {
                target: upperLabel
                visible: true
            }
        },
        State {
            name: "acquisitionState"
            when: bargraph_res_bargraphType.value === 5
            PropertyChanges {
                target: centralProgressItem
                visible: true
            }
            PropertyChanges {
                target: testConnectorItem
                visible: false
            }
            PropertyChanges {
                target: acquisitionProgressBar
                visible: true
            }
            PropertyChanges {
                target: leftLabel
                visible: true
            }

            PropertyChanges {
                target: rightLabel
                visible: true
            }

            PropertyChanges {
                target: upperLabel
                visible: true
            }
        },
        State {
            name: "nominalState"
            when: bargraph_res_bargraphType.value === 0
            PropertyChanges {
                target: centralProgressItem
                visible: true
            }
            PropertyChanges {
                target: testConnectorItem
                visible: false
            }
            PropertyChanges {
                target: acquisitionProgressBar
                visible: true
            }
            PropertyChanges {
                target: leftLabel
                visible: true
            }
            PropertyChanges {
                target: upperLabel
                visible: true
            }
            PropertyChanges {
                target: rightLabel
                visible: true
            }
        }
    ]
    Rectangle {
        id: rectColumn
        anchors.top: parent.top
        width: parent.width
        height: childrenRect.height
        visible: bargraph_res_isFiberDataVisible.value
        Column {
            id: columnId
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.leftMargin: ViaviStyle.layout.largeMargin
            anchors.rightMargin: ViaviStyle.layout.largeMargin
            anchors.top: parent.top

            property real passCellWidth: ViaviStyle.layout.veryLargeMargin
            property real cellWidth : (width - passCellWidth) / 4

            TableHeaderRow {
                id: header
                visible: bargraph_res_isFiberDataVisible.value
                TableHeaderCell {
                    width: columnId.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: bargraph_res_laserLabel.value
                }
                TableHeaderCell {
                    width: columnId.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: bargraph_res_lossLabel.value
                }
                TableHeaderCell {
                    width: columnId.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: bargraph_res_orlLabel.value
                }
                TableHeaderCell {
                    width: columnId.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: bargraph_res_attenuationLabel.value
                }
                TableHeaderCell{
                    width: columnId.passCellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    //valueText: "P/F"
                    valueText: fibers_res_passLabel.value
                }
            }
            Rectangle {
                id: rectListView
                width: parent.width
                height: childrenRect.height
                
                ListView {
                    id: theListView
                    boundsBehavior: Flickable.OvershootBounds
                    model: bargraph_res_bargraphData.value

                    height: childrenRect.height

                    delegate: TableRow {
                        TableTextCell {
                            width: columnId.cellWidth
                            valueTextHorizontalAllignment: Text.AlignHCenter
                            valueTextVerticalAlignment: Text.AlignVCenter
                            valueText: laser
                        }
                        TableTextCell {
                            width: columnId.cellWidth
                            valueTextHorizontalAllignment: Text.AlignHCenter
                            valueTextVerticalAlignment: Text.AlignVCenter
                            valueColor: ViaviStyle.colors.getTextColor(alarm_loss)
                            valueText: loss
                        }
                        TableTextCell {
                            width: columnId.cellWidth
                            valueTextHorizontalAllignment: Text.AlignHCenter
                            valueTextVerticalAlignment: Text.AlignVCenter
                            valueColor: ViaviStyle.colors.getTextColor(alarm_orl)
                            valueText: orl
                        }
                        TableTextCell {
                            width: columnId.cellWidth
                            valueTextHorizontalAllignment: Text.AlignHCenter
                            valueTextVerticalAlignment: Text.AlignVCenter
                            valueText: attenuation
                        }
                        Image {
                            anchors.top: parent.top
                            anchors.bottom: parent.bottom
                            width: columnId.passCellWidth
                            fillMode: Image.PreserveAspectFit
                            source: pass
                        }
                    }
                }
            }
        }
    }
    Rectangle {
        id: rectProgressBar
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.top:bargraph_res_isFiberDataVisible.value? rectColumn.bottom : parent.top
        anchors.bottom: parent.bottom
        width: parent.width
        visible: bargraph_res_isBarGraphVisible.value
        Item {
            id: centralProgressItem

            width: parent.width / 2
            height: ViaviStyle.layout.genericTableLineHeight //traditionally the progress bar had the size of the table cell
            anchors.top: upperLabel.bottom
            anchors.horizontalCenter: parent.horizontalCenter
            property alias acquisitionProgressBar: acquisitionProgressBar
            property alias testConnectorItem: testConnectorItem
            clip: true
            /* Test connector progress bar */
            Item {
                id: testConnectorItem
                anchors.fill: parent

                Row {
                    Repeater {
                        /* we had 6 segments in the original design, decided to keep the aspect */
                        model: 6
                        Rectangle {
                            /* width is based on the 6 original segments */
                            width: centralProgressItem.width / 6
                            height: centralProgressItem.height

                            border.color: ViaviStyle.colors.borderColor
                            border.width: ViaviStyle.layout.borderSmallWidth
                        }
                    }
                }

                Rectangle {

                    visible: bargraph_res_bargraphPercent.value > 0

                    anchors.verticalCenter: parent.verticalCenter
                    anchors.left: parent.left
                    /* calculate marker position and let 'clip' ensure the boundaries */
                    anchors.leftMargin: bargraph_res_bargraphPercent.value
                                        * centralProgressItem.width / 100 - width / 2

                    /* purely subjective marker size, feel free to change it and the calculations will work */
                    width: centralProgressItem.width / 8
                    height: centralProgressItem.height - 4

                    color: bargraph_res_bargraphPercent.value
                           >= 50 ? ViaviStyle.colors.passColor : bargraph_res_bargraphPercent.value
                                   >= 20 ? ViaviStyle.colors.warningColor : ViaviStyle.colors.failedColor
                }
            }

            /* Acquistion progress bar */
            Rectangle {
                id: acquisitionProgressBar

                radius: 2
                color: ViaviStyle.colors.pageBackgroundColor
                border.color: ViaviStyle.colors.borderColor
                border.width: ViaviStyle.layout.borderSmallWidth

                anchors.fill: parent

                property int from: 0
                property int to: 100
                /* binding doesn't work but I'll leave it here for inspiration */
                property int value: bargraph_res_bargraphPercent.value
                                    >= 0 ? bargraph_res_bargraphPercent.value : 0

                Rectangle {
                    color: ViaviStyle.colors.activeColor

                    anchors.left: parent.left
                    height: parent.height
                    width: parent.width * acquisitionProgressBar.value / acquisitionProgressBar.to

                    // progress label displayed on the bargraph
                    Text {
                        id: progressLabel

                        visible: parent.width > contentWidth + ViaviStyle.layout.smallMargin
                        anchors.verticalCenter: parent.verticalCenter
                        anchors.right: parent.right
                        anchors.rightMargin: ViaviStyle.layout.smallMargin

                        color: ViaviStyle.colors.activeItemTextColor
                        text: bargraph_res_bargraphPercent.value + "%"
                        font: ViaviStyle.layout.mediumBoldFont
                    }
                }

                /* Used connections because the ProgressBar value binding doesn't work */
                Connections {
                    target: bargraph_res_bargraphPercent
                    function onValueChanged() {
                    	acquisitionProgressBar.value = bargraph_res_bargraphPercent.value
                    }
                }
            }
        }

        /* Upper label */
        Text {
            id: upperLabel
            anchors.top: parent.top
            anchors.topMargin: ViaviStyle.layout.smallMargin
            anchors.horizontalCenter: parent.horizontalCenter

            color: ViaviStyle.colors.mainInfoColor
            text: bargraph_res_bargraphUpLabel.value
            font: ViaviStyle.layout.largeBoldFont
        }

        /* Left label */
        Text {
            id: leftLabel

            anchors.right: centralProgressItem.left
            anchors.rightMargin: ViaviStyle.layout.mediumMargin
            anchors.verticalCenter: centralProgressItem.verticalCenter

            color: ViaviStyle.colors.mainInfoColor
            text: bargraph_res_bargraphLeftLabel.value
            font: ViaviStyle.layout.largeBoldFont
        }

        /* Right label */
        Text {
            id: rightLabel

            anchors.left: centralProgressItem.right
            anchors.leftMargin: ViaviStyle.layout.mediumMargin
            anchors.verticalCenter: centralProgressItem.verticalCenter

            color: ViaviStyle.colors.mainInfoColor
            text: bargraph_res_bargraphRightLabel.value
            font: ViaviStyle.layout.largeBoldFont
        }
    }
}
