import QtQuick 2.5
import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui.components 1.0

BasicContainer {
    id: analysisRoot
    property int methodType: 0

    height: ViaviStyle.layout.buttonHeight //tab selection
            + ViaviStyle.layout.mediumMargin
            + ViaviStyle.layout.buttonHeight //calculate button
            + ViaviStyle.layout.mediumMargin

    Rectangle {
        id: buttonRow

        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        height: ViaviStyle.layout.buttonHeight

        color: ViaviStyle.colors.borderColor

        Row {
            id:upperRow
            anchors.left: parent.left
            anchors.leftMargin: ViaviStyle.layout.largeMargin
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            width: parent.width / 2
            spacing: ViaviStyle.layout.mediumMargin

            function resetResultText()
            {
                analysis_act_reset.invoke()
            }

            CheckTextButton {

                height: parent.height
                width: parent.width / 4
                checked: analysis_cfg_measType.value === analysis_cfg_measType.enums.emtLoss

                text: analysis_res_lossBtnLabel.value
                centerContent: true

                mouseArea.onClicked: {
                    analysis_cfg_measType.value = analysis_cfg_measType.enums.emtLoss
                    upperRow.resetResultText()
                }
            }

            CheckTextButton {
                height: parent.height
                width: parent.width / 4
                checked: analysis_cfg_measType.value === analysis_cfg_measType.enums.emtOrl

                text: analysis_res_orlBtnLabel.value
                centerContent: true

                mouseArea.onClicked: {
                    analysis_cfg_measType.value = analysis_cfg_measType.enums.emtOrl
                    upperRow.resetResultText()
                }
            }
            CheckTextButton {
                height: parent.height
                width: parent.width / 4
                checked: analysis_cfg_measType.value === analysis_cfg_measType.enums.emtReflect

                text: analysis_res_reflectBtnLabel.value
                centerContent: true

                mouseArea.onClicked: {
                    analysis_cfg_measType.value = analysis_cfg_measType.enums.emtReflect
                    upperRow.resetResultText()
                }
            }

            CheckTextButton {
                height: parent.height
                width: parent.width / 4
                checked: analysis_cfg_measType.value === analysis_cfg_measType.enums.emtSlope

                text: analysis_res_slopeBtnLabel.value
                centerContent: true

                mouseArea.onClicked: {
                    analysis_cfg_measType.value = analysis_cfg_measType.enums.emtSlope
                    upperRow.resetResultText()
                }
            }
        }
    }

    
    RowLayout {
        id: methodComboBoxItem
        visible: analysis_cfg_measType.value === analysis_cfg_measType.enums.emtLoss
        anchors.top: buttonRow.bottom
        anchors.bottom: parent.bottom
        anchors.left:  parent.left
        anchors.leftMargin: ViaviStyle.layout.largeMargin
        //width: parent.width * 0.
        Text {
            id: methodComboBoxText
            Layout.fillWidth: true
            Layout.fillHeight: true
            horizontalAlignment : Text.AlignHCenter
            verticalAlignment : Text.AlignVCenter
            //wrapMode : Text.Wrap
            text: analysis_res_methodTextLabel.value + ':'
            font: ViaviStyle.layout.largeFont
            color: ViaviStyle.colors.mainInfoColor
        }
        ViaviComboBox {
            model: analysis_res_methodList.value
            textRole: 'text'
            onCurrentIndexChanged: analysis_cfg_selectedMethod.value = currentIndex
            Component.onCompleted: currentIndex = analysis_cfg_selectedMethod.value
        }
    }

        // Remove result information for now, leave placeholder for it 
        RowLayout {
            id: itemResult
            visible: true
            anchors.top: buttonRow.bottom
            anchors.bottom: parent.bottom
            anchors.left:  methodComboBoxItem.visible === true ? methodComboBoxItem.right : parent.left
            anchors.leftMargin: ViaviStyle.layout.largeMargin
            anchors.right: calculateButton.left
            anchors.rightMargin: ViaviStyle.layout.largeMargin
            height: analysisResultValue.contentHeight
            Text {
                id: analysisResultValue
                Layout.fillWidth: true
                Layout.fillHeight: true
                fontSizeMode : Text.Fit
                text: analysis_res_resultTextLabel.value
                verticalAlignment : Text.AlignVCenter
                wrapMode : Text.Wrap
                font: ViaviStyle.layout.numericValueFont
                color: ViaviStyle.colors.mainInfoColor
            }

            Text {
                Layout.fillWidth: true
                Layout.fillHeight: true
                fontSizeMode : Text.Fit
                text: analysis_res_resultUnitTextLabel.value
                font: ViaviStyle.layout.numericConfigFont
                color: ViaviStyle.colors.mainInfoColor
            }
        }

    Button {
        id: calculateButton
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layout.largeMargin
        anchors.bottom: parent.bottom
        anchors.bottomMargin: ViaviStyle.layout.mediumMargin
        width: ViaviStyle.layout.buttonHeight * 4
        height: ViaviStyle.layout.buttonHeight
        text: analysis_res_calculateBtnLabel.value

        onClicked: {
            analysis_act_calculate.invoke()
        }
    }
}
