<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\view;

/**
 * Generates an html test page;
 *
 * @author Sylvain Desplat
 */
class SMTTestRestApiPage implements SMTIPage
{
	const TEST_FILE = "app/view/SMTTestRestApiLayout.php";

	private $htmlFile;
	private $url = NULL;
	private $httpMethod = NULL;
	private $json_string = NULL;
	
	/**
	 * By default execute a PUT request
	 * 
	 * @param string $url 
	 * @param string $json_string
	 * @param string $httpMethod : PUT, GET, POST, DELETE
	 */
	function __construct( $url, $json_string, $httpMethod = 'PUT' )
	{
		$this->htmlFile = self::TEST_FILE;
		$this->url = $url;
		$this->httpMethod = $httpMethod;
		$this->json_string = $json_string;
	}

	/**
	 * Generate a notification page with the given message
	 *
	 * @return page generation status
	 */
	function generatePage()
	{
		//retrieve variables used in htmlFile
		$url = $this->url;
		$json_string = $this->json_string;
		$httpMethod = $this->httpMethod;
		ob_start();
		require $this->htmlFile;
		return ob_end_flush();
	}
}
?>