<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTRwDto;
use app\serviceshelper\ethernet\SMTFirewall;
use app\serviceshelper\maintenance\SMTLicence;

/**
 * Container of ethernet config Dto with hostname, ipv4 config and ipv6 config 
 * 
 * @author Sylvain Desplat
 */
class SMTEthernetDto extends SMTRwDto
{
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTIpv4Dto')
     * @var app\services\setup\SMTIpv4Dto
     */
    protected $ipv4 = NULL;
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTIpv6Dto')
     * @var app\services\setup\SMTIpv6Dto
     */
    protected $ipv6= NULL;
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTIpv4Dto')
     * @var app\services\setup\SMTIpv4Dto
     */
    protected $ipv4Backup = NULL;
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTIpv6Dto')
     * @var app\services\setup\SMTIpv6Dto
     */
    protected $ipv6Backup= NULL;
    
    /**
     * The host name otu the OTU
     * @var string
     */
    protected $hostName = "";

    /**
     * Whether a reboot is required because the ip settings were modified
     * @var boolean
     */
    protected $reboot = FALSE;
       
    /**
     * Firewall mode
     * 
     * @var string
     */
    protected  $firewallMode = SMTFirewall::FIREWALL_OFF;
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTCustomFirewallDto')
     * @var app\services\setup\SMTCustomFirewallDto
     */
    protected $customFirewall;
    
    /**
     * Whether the enhanced security mode is active
     * @var string
     */
    protected $enhancedSecurity = SMTLicence::ENHANCED_SECURITY_OFF;
    
    /**
     * 
     * @var boolean
     */
    protected $backupRouteActive = FALSE;
    
    /**
     *
     * @var string
     */
    protected $backupRouteIp = "0.0.0.0";
    
    /**
     * ETH1 active on OTH
     * @var boolean
     */
    protected $secondETHActive = FALSE;
    
    /**
     * 
     * @param string $hostName
     */
    function setHostName( $hostName)
    {
        $this->hostName = $hostName;
    }
    
    /**
     *
     * @return string hostName
     */
    function getHostName()
    {
    	return $this->hostName;
    }
    
    /**
     *
     * @param boolean $backupRouteActive
     */
    function setBackupRouteActive( $backupRouteActive)
    {
    	$this->backupRouteActive= $backupRouteActive;
    }
    
    /**
     *
     * @return boolean
     */
    function getBackupRouteActive()
    {
    	return $this->backupRouteActive;
    }
    
    /**
     *
     * @param string $backupRouteIp
     */
    function setBackupRouteIp( $backupRouteIp)
    {
    	$this->backupRouteIp= $backupRouteIp;
    }
    
    /**
     *
     * @return string
     */
    function getBackupRouteIp()
    {
    	return $this->backupRouteIp;
    }
    
    /**
     *
     * @param boolean $secondETHActive
     */
    function set_Second_ETH_Active( $secondETHActive)
    {
        $this->secondETHActive= $secondETHActive;
    }
    
    /**
     *
     * @return boolean
     */
    function get_Second_ETH_Active()
    {
        return $this->secondETHActive;
    }
    
    /**
     * Set whether a reboot is required because the ip settings were modified
     * 
     * @param boolean
     */
    public function setReboot( $reboot )
    {
    	$this->reboot = $reboot;
    }
    
    /**
     * Whether a reboot is required because the ip settings were modified
     * @return boolean
     */
    public function isReboot()
    {
    	return $this->reboot;
    }    
    
    /**
     * @param $firewallMode string
     */
    public function setFirewallMode( $firewallMode )
    {
    	return $this->firewallMode = $firewallMode;
    }
    
    /**
     * Returns the firewall mode:
     * 
     * @return string
     */
    public function getFirewallMode()
    {
    	return $this->firewallMode;
    }
    
    /**
     * 
     * @param app\services\setup\SMTIpv4Dto $ipv4
     */
    function setIpv4( $ipv4 )
    {
        $this->ipv4 = $ipv4;
    }
    
    /**
     *
     * @param app\services\setup\SMTIpv6Dto $ipv6
     */    
    function setIpv6( $ipv6 )
    {
        $this->ipv6 = $ipv6;
    }    
    
    /**
     *
     * @return app\services\setup\SMTIpv4Dto $ipv4
     */
    function getIpv4()
    {
    	return $this->ipv4;
    }
    
    /**
     *
     * @return app\services\setup\SMTIpv6Dto $ipv6
     */
    function getIpv6()
    {
    	return $this->ipv6;
    }
    
    /**
     *
     * @param app\services\setup\SMTIpv4Dto $ipv4
     */
    function setIpv4Backup( $ipv4 )
    {
        $this->ipv4Backup = $ipv4;
    }
    
    /**
     *
     * @param app\services\setup\SMTIpv6Dto $ipv6
     */
    function setIpv6Backup( $ipv6 )
    {
        $this->ipv6Backup = $ipv6;
    }
    
    /**
     *
     * @return app\services\setup\SMTIpv4Dto $ipv4
     */
    function getIpv4Backup()
    {
        return $this->ipv4Backup;
    }
    
    /**
     *
     * @return app\services\setup\SMTIpv6Dto $ipv6
     */
    function getIpv6Backup()
    {
        return $this->ipv6Backup;
    }
    
    /**
     *
     * @param app\services\setup\SMTCustomFirewallDto $customFirewallConfig
     */
    public function setCustomFirewall(SMTCustomFirewallDto $customFirewallConfig )
    {
    	$this->customFirewall = $customFirewallConfig;
    }
    
    /**
     *
     * @return app\services\setup\SMTCustomFirewallDto $customFirewall
     */
    public function getCustomFirewall()
    {
    	return $this->customFirewall;
    }
    
    /**
     * Set whether the enhanced security mode is activated
     *
     * @param string
     */
    public function setEnhancedSecurity( $security )
    {
    	$this->enhancedSecurity = $security;
    }
    
    /**
     * Whether the enhanced security mode is activated
     * @return string
     */
    public function getEnhancedSecurity()
    {
    	return $this->enhancedSecurity;
    }
    
    public function stripHtmlTags()
    {
    	if ( $this->ipv4!= NULL )
    	{
    		$this->ipv4->stripHtmlTags();
    	}
    	if ( $this->ipv6 != NULL )
    	{
    		$this->ipv6->stripHtmlTags();
    	}
    	if ( $this->ipv4Backup!= NULL )
    	{
    	    $this->ipv4Backup->stripHtmlTags();
    	}
    	if ( $this->ipv6Backup != NULL )
    	{
    	    $this->ipv6Backup->stripHtmlTags();
    	}
    	if ( $this->customFirewall != NULL )
    	{
    		$this->customFirewall->stripHtmlTags();
    	}
    }
    
    /**
     * Serialize as Json data the object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }   
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\setup\SMTEthernetDto
     */
    static function getInstance( array &$json_array )
    {
    	$instance = self::forge( get_class(), $json_array );
    	$instance->stripHtmlTags();
    	return $instance;
    }
}
?>