<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solutions
// Copyright JDSU 2016. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\serviceshelper\media\SMTEmailPortFilterEncoderDecoder;

use app\util\SMTRwDto;

/**
 * 
 * @author Sylvain Desplat
 */
class SMTEmailPortFilterDto extends SMTRwDto
{
	protected $selectedPortArray = array();
    protected $hasFilter = FALSE;
    protected $portCount = 1;
	
	/**
	 * @param boolean
	 */
	public function setHasFilter( $filter )
	{
		$this->hasFilter = $filter;
	}
	
	/**
	 * @return integer
	 */
	public function getPortCount()
	{
		return $this->portCount;
	}
	
	/**
	 * @param integer
	 */
	public function setPortCount( $portCount )
	{
		$this->portCount = intval($portCount);
	}
	
	/**
	 * @return boolean
	 */
	public function hasFilter()
	{
		return $this->hasFilter;
	}	
	
	/**
	 * Set array of port where email must be sent
	 * 
	 * @param int[] $selectedPortArray
	 */
	public function setPortArray( $selectedPortArray )
	{
		$this->selectedPortArray = $selectedPortArray;
	}
	
	/**
	 * @return int[]
	 */
	public function getPortArray()
	{
		return $this->selectedPortArray;
	}
	
	/**
	 * The port filter buffer in hexa for OTU parser
	 * 
	 */
	public function setPortBuffer( $portBuffer, $portCount )	
	{
		$this->selectedPortArray = SMTEmailPortFilterEncoderDecoder::decodePortFilter($portBuffer, intval($portCount));
	    $this->portCount = intval($portCount);
	}
	
	/**
	 * Build the port filter buffer in hexa for OTU parser from selected ports
	 * 
	 * @return array
	 */
	public function getPortBuffer()
	{
	    return SMTEmailPortFilterEncoderDecoder::encodePortFilter($this->selectedPortArray, $this->portCount);
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}

	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\setup\SMTEmailPortFilterDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}


?>