<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\otdr;

use app\util\SMTRwDto;
/**
 * Measurement on undeclared link acquisition parameters.
 * 
 * @author Sylvain Desplat
 */
class SMTOtdrMeasureOnDemandParametersDto extends SMTRwDto
{
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTModuleDto')
     * @var app\services\setup\SMTModuleDto
     */
    protected $otdrModule = NULL;
        
    /**
     * Default acquisition parameters
     * 
     * @SMTAttributeInfosAnnotation(classname='app\services\otdr\SMTStartOtdrMeasureOnDemandParametersDto')
     * @var app\services\otdr\SMTStartOtdrMeasureOnDemandParametersDto
     */
    protected $otdrMeasureParameters = NULL;
    
    
    /**
     * @var boolean
     */
    protected $forceUseOfParameters = FALSE;
    
    /**
     * @var string
     */
    protected $referenceTraceName;    
    
    /**
     * @param SMTStartOtdrMeasureOnDemandParametersDto $otdrMeasureParameters
     */
    public function setOtdrMeasureParameters( SMTStartOtdrMeasureOnDemandParametersDto $otdrMeasureParameters)
    {
    	$this->otdrMeasureParameters = $otdrMeasureParameters;
    }
    
    /**
     * 
     * @return \app\services\otdr\SMTStartOtdrMeasureOnDemandParametersDto
     */
    public function getOtdrMeasureParameters()
    {
    	return $this->otdrMeasureParameters;
    }
    
    public function setOtdrModule( $otdrModule)
    {
    	$this->otdrModule = $otdrModule;
    }
    
    public function getOtdrModule()
    {        
    	return $this->otdrModule;
    } 
    
    /**
     *
     * @param boolean $autoconfig
     */
    public function setForceUseOfParameters( $forceUseOfParameters )
    {
    	$this->forceUseOfParameters = $forceUseOfParameters;
    }
    
    /**
     *
     * @return boolean
     */
    public function isForceUseOfParameters()
    {
    	return $this->forceUseOfParameters;
    }
    
    /**
     * @param string $referenceTraceName
     */
    public function setReferenceTraceName( $referenceTraceName )
    {
    	$this->referenceTraceName = $referenceTraceName;
    }
    /**
     * @return $range
     */
    public function getReferenceTraceName()
    {
    	return $this->referenceTraceName;
    }
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }    
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\monitoring\SMTLinkTestDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }    
}
?>