<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of Viavi Solution
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solution
// Copyright Viavi Solution 2024. All rights reserved.
// *********************************************************
namespace app\services\api;

/**
 * 
 *
 * @author sdesplat
 */
class SMTApiMeasurementDto extends SMTApiDto
{
	/**
	 * Config file encoded in base 64
	 *
	 * @var string
	 */
	protected $config;	
	
	/**
	 * Config file SM-OTDR, MM-OTDR, DTS, COBRA
	 *
	 * @var string
	 */
	protected $configType;
	
	/**
	 * Config file type CFG or JSON
	 *
	 * @var string
	 */
	protected $configFormat;
	
	
	public function setConfigFileBase64($configFileBase64)
	{
	    $this->config= $configFileBase64;
	}
	
	public function getConfigFileContent()
	{	    
	    return base64_decode($this->config);
	}

	public function getConfigType()
	{
	    return $this->configType;
	}
	
	public function getConfigFormat()
	{
	    return $this->configFormat;
	}
	
	public function saveContent($dir, $fileName)
	{
	    file_put_contents ( $dir.$fileName, $this->getConfigFileContent(), LOCK_EX);
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties, FALSE);
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\api\SMTApiLinkDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}