<?php

// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\events;

/**
 * Wait for new events messages.
 * 
 *
 * @author Sylvain Desplat
 */
interface SMTIEventMessageConsumer
{
    /**
     * Get all the pending messages for the given consumer id.
     * That method is called by long-delay-polling
     *
     * @param string $id
     *
     * @return SMTEventConsumerDto[] the messages with the events to send to the consumer
     */
    function getMessages( $id );
    
    /**
     * Add a new measure on demand event listener for the given consumer:
     * create a measure consumer message for the given consumer.
     * WARNING: ONLY ONE CONSUMER FOR ONE OPERATION: consumerId = operationId.
     *
     * @param string $consumerId
     * @return the Event Consumer if it was created successfully and if it was not already registered
     */
    function registerMeasureOnDemandConsumer( $consumerId );
    
    /**
     * Remove the measure on demand event listener for the given consumer:
     *
     * @param string $consumerId
     */
    function unregisterMeasureOndemandEventConsumer( $consumerId );
    
    
    /**
     * Add a new activity event listener for the given consumer: create an activity message for the given consumer
     *
     * @param string $consumerId
     */
    function registerActivityEventConsumer( $consumerId );

    /**
     * Remove the activity event listener for the given consumer: remove the activity message for the given consumer
     *
     * @param string $consumerId
     */
    function unregisterActivityEventConsumer( $consumerId );

    /**
     * Add a new Optical alarm event listener for the given consumer: create an alarm message for the given consumer
     *
     * @param string $consumerId
     */
    function registerOpticalAlarmEventConsumer( $consumerId );

    /**
     * Remove the Optical alarm event listener for the given consumer: remove the alarm message for the given consumer
     *
     * @param string $consumerId
     */
    function unregisterOpticalAlarmEventConsumer( $consumerId );    
    
    /**
     * Add a new System alarm event listener for the given consumer: create an alarm message for the given consumer
     *
     * @param string $consumerId
     */
    function registerSystemAlarmEventConsumer( $consumerId );
    
    /**
     * Remove the System alarm event listener for the given consumer: remove the alarm message for the given consumer
     *
     * @param string $consumerId
    */
    function unregisterSystemAlarmEventConsumer( $consumerId );    

}
?>