<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright VIAVI Solutions 2017. All rights reserved.
// *********************************************************
namespace app\admin;    

use app\http\SMTContext;
use app\parser\SMTOtuApi;
//use app\util\SMTLogger;

/**
 * Handle the OTU type: 
 *  - retrieve it from settings
 *  - store it in session variable
 * 
 * @author Sylvain Desplat
 *
 */
class SMTOtuVersion
{        
    const DEFAULT_OTU_VERSION = '';
    const OTU_VERSION = 'OTU_VERSION';
    
    
    /**
     * Set OTU type in session
     *
     * @param string $type the OTU Version
     */
    public static function setOtuVersion( $version )
    {
        if ( strlen ($version ) > 0 )
        {
            $_SESSION[self::OTU_VERSION] = $version;
        }
    }    
    
    /**
     * Return the OTU Version
     * 
     * @return string
     */
    public static function getOtuVersion( SMTContext $context )
    {
        //update session current language
        if ( !isset($_SESSION[self::OTU_VERSION] ) || $_SESSION[self::OTU_VERSION] == NULL )
        { 
            $version = self::retrieveOtuVersion($context);
            self::setOtuVersion( $version );
        }        
        
        $version = isset($_SESSION[self::OTU_VERSION])?$_SESSION[self::OTU_VERSION]: self::DEFAULT_OTU_VERSION;
        
        return $version;
    }
    
    /**
     * Retrieve the OTU version
     * 
     * @return string
     */
    private static function retrieveOtuVersion( SMTContext $context)
    {
        $success = false;
        $version = self::DEFAULT_OTU_VERSION;
        // get OTU Version
        $otuInfo = exec('sudo /sbin/getinfoversion Otu');
        if ( strlen($otuInfo) > 0 )
        {
            $values = explode(';', $otuInfo);
            if (count($values)  > 4)
            {
                $version = trim( $values[3] );
                $success = true;
            }
        }
        if ($success == false)
        {
            $otuInfo = $context->getOtuSocket()->sendReceive( SMTOtuApi::getOtuInfo() );
            list( $company, $otuType, $serialNumber, $otuMode, $version ) = explode(",", $otuInfo);
        }
        
        return $version;
    }
    
}
?>