

from json import load, loads
from jsonpath import jsonpath
from copy import deepcopy
from typing import List, Any

import syslog
from syslog import syslog as log


class JsonProxy:
    def __init__(self, data: dict):
        """ JsonProxy constructor.

        :param data: "json-like" dictionary
        """
        self.__data: dict = data

    @classmethod
    def from_str(cls, raw_data: str):
        """TODO

        :param data: 
        :return
        """
        data = {}
        try:
            data = loads(raw_data)
            
        except ValueError as err:  # json.JSONDecodeError, UnicodeDecodeError, etc
            log(syslog.LOG_ERR, "Invalide file format: {}".format(err))

        return cls(data)

    @classmethod
    def from_file(cls, filename: str):
        """TODO
        :param filename:
        :return
        """
        raw_data = "{}"
        try:
            with open(filename, 'rb') as file:
                raw_data = file.read()

        except OSError as err:  # FileNotFoundError, IsADirectoryError, etc
            log(syslog.LOG_ERR, "File open failure: {}".format(err))
            
        return cls.from_str(raw_data)

    def get(self, path: str, default=None) -> List[Any]:
        """TODO

        :param path: json path to specific cdm entry (expected format: $.key_1.key_2.key_3...key_n)
        :param default: default output.
        :return: entry corresponding to specified cdm path, if exists
                 or default otherwise
        """
        entry = jsonpath(self.__data, path)

        return entry if entry else [default]

    @property
    def data(self) -> dict:
        return deepcopy(self.__data)
 
