from viavi.evm import *
from viavi.diag import *
from viavi.evm import *
from time import time, sleep
from viavi.upgrade.flashutils import install_release, install_pmulti
from viavi.stdhw.blockutils import get_block_devices
import hashlib
import os
import os.path
import subprocess
try:
    from urllib.request import urlopen
except ImportError:
    from urllib2 import urlopen

@DIAG("Flash Release")
def flash(cmd):
    argv = cmd.split()
    if len(argv) < 2:
        print("flash [-f] http://server/release.xml\n\t-f: Force full format device (!!! Will loose Calibration !!!)")
        return False
    if argv[1] == "-f":
        res = install_release(argv[2], True)
    else:
        res = install_release(argv[1], False)
    if res:
        print_ok("FLASH FIRMWARE SUCCESSFUL")
    else:
        print_error("FLASH FIRMWARE FAILED")

@DIAG("Flash PMulti")
def flash_pmulti(cmd):
    argv = cmd.split()
    if len(argv) < 2:
        print("flash_pmulti [-f] http://server/release.xml\n\t-f: Force full format device (!!! Will loose Calibration !!!)")
        return False
    if argv[1] == "-f":
        install_pmulti(argv[2], True)
    else:
        install_pmulti(argv[1], False)

@DIAG("Flash U-boot")
def flash_uboot(cmd):
    md5src = hashlib.md5()
    md5dest = hashlib.md5()
    argv = cmd.split()
    if len(argv) < 2:
        print("flash_uboot http://server/u-boot.imx\n\t")
        return False
    bootimg = urlopen(argv[1])
    binsrc = bootimg.read()
    md5src.update(binsrc)
    with open("/tmp/u-boot.imx", "wb") as pm:
        pm.write(binsrc)
    mmc = list(get_block_devices("MMC").keys())[0]
    cmd = "dd if=/tmp/u-boot.imx of=/dev/%s bs=1k seek=1"%mmc
    print("# %s"%cmd)
    os.system(cmd)
    os.system("sync")
    cmd = "dd if=/dev/%s of=/tmp/u-boot.imx.check bs=1k skip=1 count=%i conv=fsync"%(mmc, (len(binsrc) / 1024) + 1)
    print("# %s"%cmd)
    os.system(cmd)
    with open("/tmp/u-boot.imx.check", "rb") as pm:
        check = pm.read(len(binsrc))
    md5dest.update(check)
    print("# MD5: %s %s"%(md5dest.hexdigest(), md5src.hexdigest()))
    return (md5dest.hexdigest() == md5src.hexdigest())
